/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql.antlr.listener;

import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.tree.ParseTreeListener;
import java.util.List;
import shaded.adbmysql.io.debezium.antlr.AntlrDdlParser;
import shaded.adbmysql.io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import shaded.adbmysql.io.debezium.connector.mysql.antlr.listener.ViewSelectedColumnsParserListener;
import shaded.adbmysql.io.debezium.ddl.parser.mysql.generated.MySqlParser;
import shaded.adbmysql.io.debezium.ddl.parser.mysql.generated.MySqlParserBaseListener;
import shaded.adbmysql.io.debezium.relational.Column;
import shaded.adbmysql.io.debezium.relational.TableEditor;
import shaded.adbmysql.io.debezium.relational.TableId;
import shaded.adbmysql.io.debezium.text.ParsingException;

public class AlterViewParserListener
extends MySqlParserBaseListener {
    private final MySqlAntlrDdlParser parser;
    private final List<ParseTreeListener> listeners;
    private TableEditor tableEditor;
    private ViewSelectedColumnsParserListener selectColumnsListener;

    public AlterViewParserListener(MySqlAntlrDdlParser parser, List<ParseTreeListener> listeners) {
        this.parser = parser;
        this.listeners = listeners;
    }

    @Override
    public void enterAlterView(MySqlParser.AlterViewContext ctx) {
        if (!this.parser.skipViews()) {
            TableId tableId = this.parser.parseQualifiedTableId(ctx.fullId());
            this.tableEditor = this.parser.databaseTables().editTable(tableId);
            if (this.tableEditor == null) {
                throw new ParsingException(null, "Trying to alter view " + tableId.toString() + ", which does not exist. Query:" + AntlrDdlParser.getText(ctx));
            }
            this.tableEditor.columnNames().forEach(this.tableEditor::removeColumn);
            if (ctx.uidList() != null) {
                ctx.uidList().uid().stream().map(this.parser::parseName).forEach(columnName -> this.tableEditor.addColumn(Column.editor().name((String)columnName).create()));
            }
            this.selectColumnsListener = new ViewSelectedColumnsParserListener(this.tableEditor, this.parser);
            this.listeners.add(this.selectColumnsListener);
        }
        super.enterAlterView(ctx);
    }

    @Override
    public void exitAlterView(MySqlParser.AlterViewContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.tableEditor.addColumns(this.selectColumnsListener.getSelectedColumns());
            if (!this.tableEditor.hasDefaultCharsetName()) {
                this.tableEditor.setDefaultCharsetName(this.parser.currentDatabaseCharset());
            }
            this.parser.databaseTables().overwriteTable(this.tableEditor.create());
            this.listeners.remove(this.selectColumnsListener);
        }, this.tableEditor);
        this.parser.signalAlterView(this.parser.parseQualifiedTableId(ctx.fullId()), null, ctx);
        super.exitAlterView(ctx);
    }
}

