/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql.antlr;

import com.mysql.cj.CharsetMapping;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.CharStream;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.CommonTokenStream;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.tree.ParseTree;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import shaded.adbmysql.io.debezium.antlr.AntlrDdlParser;
import shaded.adbmysql.io.debezium.antlr.AntlrDdlParserListener;
import shaded.adbmysql.io.debezium.antlr.DataTypeResolver;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlSystemVariables;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlValueConverters;
import shaded.adbmysql.io.debezium.connector.mysql.antlr.listener.MySqlAntlrDdlParserListener;
import shaded.adbmysql.io.debezium.ddl.parser.mysql.generated.MySqlLexer;
import shaded.adbmysql.io.debezium.ddl.parser.mysql.generated.MySqlParser;
import shaded.adbmysql.io.debezium.relational.Column;
import shaded.adbmysql.io.debezium.relational.ColumnEditor;
import shaded.adbmysql.io.debezium.relational.SystemVariables;
import shaded.adbmysql.io.debezium.relational.TableEditor;
import shaded.adbmysql.io.debezium.relational.TableId;
import shaded.adbmysql.io.debezium.relational.Tables;
import shaded.adbmysql.io.debezium.relational.ddl.AbstractDdlParser;

public class MySqlAntlrDdlParser
extends AntlrDdlParser<MySqlLexer, MySqlParser> {
    private final ConcurrentMap<String, String> charsetNameForDatabase = new ConcurrentHashMap<String, String>();
    private final MySqlValueConverters converters;
    private final Tables.TableFilter tableFilter;

    public MySqlAntlrDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters) {
        this(converters, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        this(true, false, false, converters, tableFilter);
    }

    public MySqlAntlrDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, boolean includeComments, MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        super(throwErrorsFromTreeWalk, includeViews, includeComments);
        this.systemVariables = new MySqlSystemVariables();
        this.converters = converters;
        this.tableFilter = tableFilter;
    }

    @Override
    protected ParseTree parseTree(MySqlParser parser) {
        return parser.root();
    }

    @Override
    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new MySqlAntlrDdlParserListener(this);
    }

    @Override
    protected MySqlLexer createNewLexerInstance(CharStream charStreams) {
        return new MySqlLexer(charStreams);
    }

    @Override
    protected MySqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new MySqlParser(commonTokenStream);
    }

    @Override
    protected SystemVariables createNewSystemVariablesInstance() {
        return new MySqlSystemVariables();
    }

    @Override
    protected boolean isGrammarInUpperCase() {
        return true;
    }

    @Override
    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.StringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, 214), new DataTypeResolver.DataTypeEntry(12, 214, 230), new DataTypeResolver.DataTypeEntry(12, 215), new DataTypeResolver.DataTypeEntry(12, 225), new DataTypeResolver.DataTypeEntry(12, 226), new DataTypeResolver.DataTypeEntry(12, 227), new DataTypeResolver.DataTypeEntry(12, 228), new DataTypeResolver.DataTypeEntry(-15, 507), new DataTypeResolver.DataTypeEntry(-9, 507, 230), new DataTypeResolver.DataTypeEntry(-9, 216), new DataTypeResolver.DataTypeEntry(1, 214, 218), new DataTypeResolver.DataTypeEntry(12, 215, 218), new DataTypeResolver.DataTypeEntry(12, 225, 218), new DataTypeResolver.DataTypeEntry(12, 226, 218), new DataTypeResolver.DataTypeEntry(12, 227, 218), new DataTypeResolver.DataTypeEntry(12, 228, 218), new DataTypeResolver.DataTypeEntry(-15, 507, 218), new DataTypeResolver.DataTypeEntry(-9, 216, 218), new DataTypeResolver.DataTypeEntry(1, 25), new DataTypeResolver.DataTypeEntry(12, 25, 230)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, 217, 215).setSuffixTokens(218), new DataTypeResolver.DataTypeEntry(-15, 217, 25).setSuffixTokens(218), new DataTypeResolver.DataTypeEntry(-9, 507, 215).setSuffixTokens(218)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalVaryingStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, 217, 214, 230), new DataTypeResolver.DataTypeEntry(-9, 217, 25, 230)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.DimensionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(5, 188).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(5, 193).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(5, 189).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(5, 194).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(4, 190).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(4, 195).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(4, 191).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(4, 192).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(4, 198).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(4, 196).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(-5, 199).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(-5, 197).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(7, 200).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(8, 201).setSuffixTokens(202, 594, 175, 187), new DataTypeResolver.DataTypeEntry(8, 205).setSuffixTokens(202, 594, 175, 187), new DataTypeResolver.DataTypeEntry(6, 203).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(6, 204).setSuffixTokens(594, 175, 187), new DataTypeResolver.DataTypeEntry(3, 206).setSuffixTokens(594, 175, 187).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, 207).setSuffixTokens(594, 175, 187).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, 421).setSuffixTokens(594, 175, 187).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(2, 208).setSuffixTokens(594, 175, 187).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(-7, 335), new DataTypeResolver.DataTypeEntry(92, 210), new DataTypeResolver.DataTypeEntry(2014, 211), new DataTypeResolver.DataTypeEntry(93, 212), new DataTypeResolver.DataTypeEntry(-2, 218), new DataTypeResolver.DataTypeEntry(-3, 219), new DataTypeResolver.DataTypeEntry(2004, 221), new DataTypeResolver.DataTypeEntry(4, 213)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SimpleDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(91, 209), new DataTypeResolver.DataTypeEntry(2004, 220), new DataTypeResolver.DataTypeEntry(2004, 222), new DataTypeResolver.DataTypeEntry(2004, 224), new DataTypeResolver.DataTypeEntry(16, 337), new DataTypeResolver.DataTypeEntry(16, 338), new DataTypeResolver.DataTypeEntry(-5, 231)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.CollectionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, 229).setSuffixTokens(218), new DataTypeResolver.DataTypeEntry(1, 148).setSuffixTokens(218)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SpatialDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1111, 777), new DataTypeResolver.DataTypeEntry(1111, 778), new DataTypeResolver.DataTypeEntry(1111, 780), new DataTypeResolver.DataTypeEntry(1111, 781), new DataTypeResolver.DataTypeEntry(1111, 782), new DataTypeResolver.DataTypeEntry(1111, 783), new DataTypeResolver.DataTypeEntry(1111, 784), new DataTypeResolver.DataTypeEntry(1111, 785), new DataTypeResolver.DataTypeEntry(1111, 455), new DataTypeResolver.DataTypeEntry(1111, 779)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarbinaryDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2004, 223).setSuffixTokens(219)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarcharDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(12, 223).setSuffixTokens(215)));
        return dataTypeResolverBuilder.build();
    }

    public ConcurrentMap<String, String> charsetNameForDatabase() {
        return this.charsetNameForDatabase;
    }

    public String parseName(MySqlParser.UidContext uidContext) {
        return this.withoutQuotes(uidContext);
    }

    public TableId parseQualifiedTableId(MySqlParser.FullIdContext fullIdContext) {
        char[] fullTableName = fullIdContext.getText().toCharArray();
        StringBuilder component = new StringBuilder();
        String dbName = null;
        String tableName = null;
        boolean EMPTY = false;
        char lastQuote = '\u0000';
        for (int i = 0; i < fullTableName.length; ++i) {
            char c = fullTableName[i];
            if (MySqlAntlrDdlParser.isQuote(c)) {
                if (lastQuote == '\u0000') {
                    lastQuote = c;
                    continue;
                }
                if (lastQuote == c) {
                    if (i < fullTableName.length - 1 && fullTableName[i + 1] == c) {
                        component.append(c);
                        ++i;
                        continue;
                    }
                    lastQuote = '\u0000';
                    continue;
                }
                component.append(c);
                continue;
            }
            if (c == '.' && lastQuote == '\u0000') {
                dbName = component.toString();
                component = new StringBuilder();
                continue;
            }
            component.append(c);
        }
        tableName = component.toString();
        return this.resolveTableId(dbName != null ? dbName : this.currentSchema(), tableName);
    }

    public void parsePrimaryIndexColumnNames(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List<String> pkColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : MySqlAntlrDdlParser.withoutQuotes(indexColumnNameContext.STRING_LITERAL().getText());
            Column column = tableEditor.columnWithName(columnName);
            if (column != null && column.isOptional()) {
                ColumnEditor ce = column.edit().optional(false);
                if (ce.hasDefaultValue() && !ce.defaultValueExpression().isPresent()) {
                    ce.unsetDefaultValueExpression();
                }
                tableEditor.addColumn(ce.create());
            }
            return column != null ? column.name() : columnName;
        }).collect(Collectors.toList());
        tableEditor.setPrimaryKeyNames(pkColumnNames);
    }

    public String currentDatabaseCharset() {
        String charsetName = this.systemVariables.getVariable("character_set_database");
        if (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName)) {
            charsetName = this.systemVariables.getVariable("character_set_server");
        }
        return charsetName;
    }

    public String charsetForTable(TableId tableId) {
        String defaultDatabaseCharset = tableId.catalog() != null ? (String)this.charsetNameForDatabase().get(tableId.catalog()) : null;
        return defaultDatabaseCharset != null ? defaultDatabaseCharset : this.currentDatabaseCharset();
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public static List<String> extractEnumAndSetOptions(List<String> enumValues) {
        return enumValues.stream().map(AbstractDdlParser::withoutQuotes).map(MySqlAntlrDdlParser::escapeOption).collect(Collectors.toList());
    }

    public static String escapeOption(String option) {
        return option.replaceAll(",", "\\\\,").replaceAll("\\\\'", "'").replaceAll("''", "'");
    }

    public MySqlValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }

    public String extractCharset(MySqlParser.CharsetNameContext charsetNode, MySqlParser.CollationNameContext collationNode) {
        String charsetName = null;
        if (charsetNode != null && charsetNode.getText() != null) {
            charsetName = MySqlAntlrDdlParser.withoutQuotes(charsetNode.getText());
        } else if (collationNode != null && collationNode.getText() != null) {
            String collationName = MySqlAntlrDdlParser.withoutQuotes(collationNode.getText()).toLowerCase();
            for (int index = 0; index < 1024; ++index) {
                if (!collationName.equals(CharsetMapping.getStaticCollationNameForCollationIndex(index))) continue;
                charsetName = CharsetMapping.getStaticMysqlCharsetNameForCollationIndex(index);
                break;
            }
        }
        return charsetName;
    }
}

