/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql;

import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.jmx.BinaryLogClientStatistics;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import shaded.adbmysql.io.debezium.connector.base.ChangeEventQueueMetrics;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlDatabaseSchema;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlPartition;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetricsMXBean;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlTaskContext;
import shaded.adbmysql.io.debezium.pipeline.metrics.DefaultStreamingChangeEventSourceMetrics;
import shaded.adbmysql.io.debezium.pipeline.source.spi.EventMetadataProvider;
import shaded.adbmysql.io.debezium.util.Collect;

public class MySqlStreamingChangeEventSourceMetrics
extends DefaultStreamingChangeEventSourceMetrics<MySqlPartition>
implements MySqlStreamingChangeEventSourceMetricsMXBean {
    private final BinaryLogClient client;
    private final BinaryLogClientStatistics stats;
    private final MySqlDatabaseSchema schema;
    private final AtomicLong numberOfCommittedTransactions = new AtomicLong();
    private final AtomicLong numberOfRolledBackTransactions = new AtomicLong();
    private final AtomicLong numberOfNotWellFormedTransactions = new AtomicLong();
    private final AtomicLong numberOfLargeTransactions = new AtomicLong();
    private final AtomicBoolean isGtidModeEnabled = new AtomicBoolean(false);
    private final AtomicLong milliSecondsBehindMaster = new AtomicLong();
    private final AtomicReference<String> lastTransactionId = new AtomicReference();

    public MySqlStreamingChangeEventSourceMetrics(MySqlTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider) {
        super(taskContext, changeEventQueueMetrics, metadataProvider);
        this.client = taskContext.getBinaryLogClient();
        this.stats = new BinaryLogClientStatistics(this.client);
        this.schema = taskContext.getSchema();
        this.milliSecondsBehindMaster.set(-1L);
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public String getBinlogFilename() {
        return this.client.getBinlogFilename();
    }

    @Override
    public long getBinlogPosition() {
        return this.client.getBinlogPosition();
    }

    @Override
    public String getGtidSet() {
        return this.client.getGtidSet();
    }

    @Override
    public boolean getIsGtidModeEnabled() {
        return this.isGtidModeEnabled.get();
    }

    @Override
    public String getLastEvent() {
        return this.stats.getLastEvent();
    }

    @Override
    public long getMilliSecondsSinceLastEvent() {
        return this.stats.getSecondsSinceLastEvent() * 1000L;
    }

    @Override
    public long getTotalNumberOfEventsSeen() {
        return this.stats.getTotalNumberOfEventsSeen();
    }

    @Override
    public long getNumberOfSkippedEvents() {
        return this.stats.getNumberOfSkippedEvents();
    }

    @Override
    public long getNumberOfDisconnects() {
        return this.stats.getNumberOfDisconnects();
    }

    @Override
    public void reset() {
        this.stats.reset();
        this.numberOfCommittedTransactions.set(0L);
        this.numberOfRolledBackTransactions.set(0L);
        this.numberOfNotWellFormedTransactions.set(0L);
        this.numberOfLargeTransactions.set(0L);
        this.lastTransactionId.set(null);
        this.isGtidModeEnabled.set(false);
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.numberOfCommittedTransactions.get();
    }

    @Override
    public long getNumberOfRolledBackTransactions() {
        return this.numberOfRolledBackTransactions.get();
    }

    @Override
    public long getNumberOfNotWellFormedTransactions() {
        return this.numberOfNotWellFormedTransactions.get();
    }

    @Override
    public long getNumberOfLargeTransactions() {
        return this.numberOfLargeTransactions.get();
    }

    public void onCommittedTransaction() {
        this.numberOfCommittedTransactions.incrementAndGet();
    }

    public void onRolledBackTransaction() {
        this.numberOfRolledBackTransactions.incrementAndGet();
    }

    public void onNotWellFormedTransaction() {
        this.numberOfNotWellFormedTransactions.incrementAndGet();
    }

    public void onLargeTransaction() {
        this.numberOfLargeTransactions.incrementAndGet();
    }

    public void onGtidChange(String gtid) {
        this.lastTransactionId.set(gtid);
    }

    public void setIsGtidModeEnabled(boolean enabled) {
        this.isGtidModeEnabled.set(enabled);
    }

    public void setMilliSecondsBehindSource(long value) {
        this.milliSecondsBehindMaster.set(value);
    }

    @Override
    public String[] getMonitoredTables() {
        return this.schema.capturedTablesAsStringArray();
    }

    @Override
    public String[] getCapturedTables() {
        return this.schema.capturedTablesAsStringArray();
    }

    @Override
    public long getMilliSecondsBehindSource() {
        return this.milliSecondsBehindMaster.get();
    }

    @Override
    public Map<String, String> getSourceEventPosition() {
        return Collect.hashMapOf("filename", this.getBinlogFilename(), "position", Long.toString(this.getBinlogPosition()), "gtid", this.getGtidSet());
    }

    @Override
    public String getLastTransactionId() {
        return this.lastTransactionId.get();
    }
}

