/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlConnectorConfig;
import shaded.adbmysql.io.debezium.pipeline.spi.Partition;
import shaded.adbmysql.io.debezium.util.Collect;

public class MySqlPartition
implements Partition {
    private static final String SERVER_PARTITION_KEY = "server";
    private final String serverName;

    public MySqlPartition(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public Map<String, String> getSourcePartition() {
        return Collect.hashMapOf(SERVER_PARTITION_KEY, this.serverName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MySqlPartition other = (MySqlPartition)obj;
        return Objects.equals(this.serverName, other.serverName);
    }

    public int hashCode() {
        return this.serverName.hashCode();
    }

    public String toString() {
        return "MySqlPartition [sourcePartition=" + this.getSourcePartition() + "]";
    }

    public static class Provider
    implements Partition.Provider<MySqlPartition> {
        private final MySqlConnectorConfig connectorConfig;

        public Provider(MySqlConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        @Override
        public Set<MySqlPartition> getPartitions() {
            return Collections.singleton(new MySqlPartition(this.connectorConfig.getLogicalName()));
        }
    }
}

