/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import shaded.adbmysql.io.debezium.connector.SnapshotRecord;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlConnectorConfig;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlReadOnlyIncrementalSnapshotContext;
import shaded.adbmysql.io.debezium.connector.mysql.SourceInfo;
import shaded.adbmysql.io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import shaded.adbmysql.io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import shaded.adbmysql.io.debezium.pipeline.spi.OffsetContext;
import shaded.adbmysql.io.debezium.pipeline.txmetadata.TransactionContext;
import shaded.adbmysql.io.debezium.relational.TableId;
import shaded.adbmysql.io.debezium.schema.DataCollectionId;

public class MySqlOffsetContext
implements OffsetContext {
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    public static final String EVENTS_TO_SKIP_OFFSET_KEY = "event";
    public static final String TIMESTAMP_KEY = "ts_sec";
    public static final String GTID_SET_KEY = "gtids";
    public static final String NON_GTID_TRANSACTION_ID_FORMAT = "file=%s,pos=%s";
    private final Schema sourceInfoSchema;
    private final SourceInfo sourceInfo;
    private boolean snapshotCompleted;
    private final TransactionContext transactionContext;
    private final IncrementalSnapshotContext<TableId> incrementalSnapshotContext;
    private String restartGtidSet;
    private String currentGtidSet;
    private String restartBinlogFilename;
    private long restartBinlogPosition = 0L;
    private int restartRowsToSkip = 0;
    private long restartEventsToSkip = 0L;
    private long currentEventLengthInBytes = 0L;
    private boolean inTransaction = false;
    private String transactionId = null;

    public MySqlOffsetContext(boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext, SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        this.sourceInfoSchema = sourceInfo.schema();
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            sourceInfo.setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
        this.transactionContext = transactionContext;
        this.incrementalSnapshotContext = incrementalSnapshotContext;
    }

    public MySqlOffsetContext(MySqlConnectorConfig connectorConfig, boolean snapshot, boolean snapshotCompleted, SourceInfo sourceInfo) {
        this(snapshot, snapshotCompleted, new TransactionContext(), connectorConfig.isReadOnlyConnection() ? new MySqlReadOnlyIncrementalSnapshotContext() : new SignalBasedIncrementalSnapshotContext(), sourceInfo);
    }

    @Override
    public Map<String, ?> getOffset() {
        Map<String, Object> offset = this.offsetUsingPosition(this.restartRowsToSkip);
        if (this.sourceInfo.isSnapshot()) {
            if (!this.snapshotCompleted) {
                offset.put("snapshot", true);
            }
        } else {
            return this.incrementalSnapshotContext.store(this.transactionContext.store(offset));
        }
        return offset;
    }

    private Map<String, Object> offsetUsingPosition(long rowsToSkip) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.sourceInfo.getServerId() != 0L) {
            map.put("server_id", this.sourceInfo.getServerId());
        }
        if (this.restartGtidSet != null) {
            map.put(GTID_SET_KEY, this.restartGtidSet);
        }
        map.put("file", this.restartBinlogFilename);
        map.put("pos", this.restartBinlogPosition);
        if (this.restartEventsToSkip != 0L) {
            map.put(EVENTS_TO_SKIP_OFFSET_KEY, this.restartEventsToSkip);
        }
        if (rowsToSkip != 0L) {
            map.put("row", rowsToSkip);
        }
        if (this.sourceInfo.timestamp() != null) {
            map.put(TIMESTAMP_KEY, this.sourceInfo.timestamp().getEpochSecond());
        }
        return map;
    }

    @Override
    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    @Override
    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    @Override
    public boolean isSnapshotRunning() {
        return this.sourceInfo.isSnapshot() && !this.snapshotCompleted;
    }

    public boolean isSnapshotCompleted() {
        return this.snapshotCompleted;
    }

    @Override
    public void preSnapshotStart() {
        this.sourceInfo.setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
    }

    @Override
    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    @Override
    public void postSnapshotCompletion() {
        this.sourceInfo.setSnapshot(SnapshotRecord.FALSE);
    }

    private void setTransactionId() {
        this.transactionId = this.sourceInfo.getCurrentGtid() != null ? this.sourceInfo.getCurrentGtid() : String.format(NON_GTID_TRANSACTION_ID_FORMAT, this.restartBinlogFilename, this.restartBinlogPosition);
    }

    private void resetTransactionId() {
        this.transactionId = null;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setInitialSkips(long restartEventsToSkip, int restartRowsToSkip) {
        this.restartEventsToSkip = restartEventsToSkip;
        this.restartRowsToSkip = restartRowsToSkip;
    }

    public static MySqlOffsetContext initial(MySqlConnectorConfig config) {
        MySqlOffsetContext offset = new MySqlOffsetContext(config, false, false, new SourceInfo(config));
        offset.setBinlogStartPoint("", 0L);
        return offset;
    }

    @Override
    public void markLastSnapshotRecord() {
        this.sourceInfo.setSnapshot(SnapshotRecord.LAST);
    }

    @Override
    public void event(DataCollectionId tableId, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.tableEvent((TableId)tableId);
    }

    public void databaseEvent(String database, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.databaseEvent(database);
        this.sourceInfo.tableEvent((TableId)null);
    }

    public void tableEvent(String database, Set<TableId> tableIds, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.databaseEvent(database);
        this.sourceInfo.tableEvent(tableIds);
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public void incrementalSnapshotEvents() {
        this.sourceInfo.setSnapshot(SnapshotRecord.INCREMENTAL);
    }

    @Override
    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.incrementalSnapshotContext;
    }

    public void setBinlogStartPoint(String binlogFilename, long positionOfFirstEvent) {
        assert (positionOfFirstEvent >= 0L);
        if (binlogFilename != null) {
            this.sourceInfo.setBinlogPosition(binlogFilename, positionOfFirstEvent);
            this.restartBinlogFilename = binlogFilename;
        } else {
            this.sourceInfo.setBinlogPosition(this.sourceInfo.getCurrentBinlogFilename(), positionOfFirstEvent);
        }
        this.restartBinlogPosition = positionOfFirstEvent;
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
    }

    public void setCompletedGtidSet(String gtidSet) {
        if (gtidSet != null && !gtidSet.trim().isEmpty()) {
            String trimmedGtidSet;
            this.currentGtidSet = trimmedGtidSet = gtidSet.replaceAll("\n", "").replaceAll("\r", "");
            this.restartGtidSet = trimmedGtidSet;
        }
    }

    public String gtidSet() {
        return this.currentGtidSet != null ? this.currentGtidSet : null;
    }

    public void startGtid(String gtid, String gtidSet) {
        this.sourceInfo.startGtid(gtid);
        if (gtidSet != null && !gtidSet.trim().isEmpty()) {
            String trimmedGtidSet = gtidSet.replaceAll("\n", "").replaceAll("\r", "");
            this.restartGtidSet = this.currentGtidSet != null ? this.currentGtidSet : trimmedGtidSet;
            this.currentGtidSet = trimmedGtidSet;
        }
    }

    public SourceInfo getSource() {
        return this.sourceInfo;
    }

    public void startNextTransaction() {
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
        this.restartBinlogFilename = this.sourceInfo.binlogFilename();
        this.restartBinlogPosition = this.sourceInfo.binlogPosition();
        this.inTransaction = true;
        this.setTransactionId();
    }

    public void commitTransaction() {
        this.restartGtidSet = this.currentGtidSet;
        this.restartBinlogFilename = this.sourceInfo.binlogFilename();
        this.restartBinlogPosition = this.sourceInfo.binlogPosition() + this.currentEventLengthInBytes;
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
        this.inTransaction = false;
        this.sourceInfo.setQuery(null);
        this.resetTransactionId();
    }

    public void completeEvent() {
        ++this.restartEventsToSkip;
    }

    public void setEventPosition(long positionOfCurrentEvent, long eventSizeInBytes) {
        this.sourceInfo.setEventPosition(positionOfCurrentEvent);
        this.currentEventLengthInBytes = eventSizeInBytes;
        if (!this.inTransaction) {
            this.restartBinlogPosition = positionOfCurrentEvent + eventSizeInBytes;
            this.restartRowsToSkip = 0;
            this.restartEventsToSkip = 0L;
        }
    }

    public void setQuery(String query) {
        this.sourceInfo.setQuery(query);
    }

    public void changeEventCompleted() {
        this.restartRowsToSkip = 0;
    }

    public long eventsToSkipUponRestart() {
        return this.restartEventsToSkip;
    }

    public int rowsToSkipUponRestart() {
        return this.restartRowsToSkip;
    }

    public void setRowNumber(int eventRowNumber, int totalNumberOfRows) {
        this.sourceInfo.setRowNumber(eventRowNumber);
        this.restartRowsToSkip = eventRowNumber < totalNumberOfRows - 1 ? eventRowNumber + 1 : totalNumberOfRows;
    }

    public void setBinlogServerId(long serverId) {
        this.sourceInfo.setBinlogServerId(serverId);
    }

    public void setBinlogThread(long threadId) {
        this.sourceInfo.setBinlogThread(threadId);
    }

    public String toString() {
        return "MySqlOffsetContext [sourceInfoSchema=" + this.sourceInfoSchema + ", sourceInfo=" + this.sourceInfo + ", snapshotCompleted=" + this.snapshotCompleted + ", transactionContext=" + this.transactionContext + ", restartGtidSet=" + this.restartGtidSet + ", currentGtidSet=" + this.currentGtidSet + ", restartBinlogFilename=" + this.restartBinlogFilename + ", restartBinlogPosition=" + this.restartBinlogPosition + ", restartRowsToSkip=" + this.restartRowsToSkip + ", restartEventsToSkip=" + this.restartEventsToSkip + ", currentEventLengthInBytes=" + this.currentEventLengthInBytes + ", inTransaction=" + this.inTransaction + ", transactionId=" + this.transactionId + ", incrementalSnapshotContext =" + this.incrementalSnapshotContext + "]";
    }

    public static class Loader
    implements OffsetContext.Loader<MySqlOffsetContext> {
        private final MySqlConnectorConfig connectorConfig;

        public Loader(MySqlConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        @Override
        public MySqlOffsetContext load(Map<String, ?> offset) {
            boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot")) || "true".equals(offset.get("snapshot"));
            boolean snapshotCompleted = Boolean.TRUE.equals(offset.get(MySqlOffsetContext.SNAPSHOT_COMPLETED_KEY)) || "true".equals(offset.get(MySqlOffsetContext.SNAPSHOT_COMPLETED_KEY));
            String binlogFilename = (String)offset.get("file");
            if (binlogFilename == null) {
                throw new ConnectException("Source offset 'file' parameter is missing");
            }
            long binlogPosition = this.longOffsetValue(offset, "pos");
            IncrementalSnapshotContext incrementalSnapshotContext = this.connectorConfig.isReadOnlyConnection() ? MySqlReadOnlyIncrementalSnapshotContext.load(offset) : SignalBasedIncrementalSnapshotContext.load(offset);
            MySqlOffsetContext offsetContext = new MySqlOffsetContext(snapshot, snapshotCompleted, TransactionContext.load(offset), incrementalSnapshotContext, new SourceInfo(this.connectorConfig));
            offsetContext.setBinlogStartPoint(binlogFilename, binlogPosition);
            offsetContext.setInitialSkips(this.longOffsetValue(offset, MySqlOffsetContext.EVENTS_TO_SKIP_OFFSET_KEY), (int)this.longOffsetValue(offset, "row"));
            offsetContext.setCompletedGtidSet((String)offset.get(MySqlOffsetContext.GTID_SET_KEY));
            return offsetContext;
        }

        private long longOffsetValue(Map<String, ?> values, String key) {
            Object obj = values.get(key);
            if (obj == null) {
                return 0L;
            }
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            try {
                return Long.parseLong(obj.toString());
            }
            catch (NumberFormatException e) {
                throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to a long");
            }
        }
    }
}

