/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql;

import java.util.function.Predicate;
import shaded.adbmysql.io.debezium.connector.mysql.GtidSet;
import shaded.adbmysql.io.debezium.document.Document;
import shaded.adbmysql.io.debezium.relational.history.HistoryRecordComparator;

final class MySqlHistoryRecordComparator
extends HistoryRecordComparator {
    private final Predicate<String> gtidSourceFilter;

    public MySqlHistoryRecordComparator(Predicate<String> gtidSourceFilter) {
        this.gtidSourceFilter = gtidSourceFilter;
    }

    @Override
    protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
        int desiredRow;
        int desiredEventCount;
        int desiredPosition;
        int desiredServerId;
        String recordedGtidSetStr = recorded.getString("gtids");
        String desiredGtidSetStr = desired.getString("gtids");
        if (desiredGtidSetStr != null) {
            if (recordedGtidSetStr != null) {
                GtidSet recordedGtidSet = new GtidSet(recordedGtidSetStr);
                GtidSet desiredGtidSet = new GtidSet(desiredGtidSetStr);
                if (this.gtidSourceFilter != null) {
                    recordedGtidSet = recordedGtidSet.retainAll(this.gtidSourceFilter);
                    desiredGtidSet = desiredGtidSet.retainAll(this.gtidSourceFilter);
                }
                if (recordedGtidSet.equals(desiredGtidSet)) {
                    int desiredEventCount2;
                    if (!recorded.has("snapshot") && desired.has("snapshot")) {
                        return false;
                    }
                    int recordedEventCount = recorded.getInteger("event", 0);
                    int diff = recordedEventCount - (desiredEventCount2 = desired.getInteger("event", 0));
                    return diff <= 0;
                }
                return recordedGtidSet.isContainedWithin(desiredGtidSet);
            }
            return true;
        }
        if (recordedGtidSetStr != null) {
            return false;
        }
        int recordedServerId = recorded.getInteger("server_id", 0);
        if (recordedServerId != (desiredServerId = recorded.getInteger("server_id", 0))) {
            long desiredTimestamp;
            long recordedTimestamp = recorded.getLong("ts_ms", 0L);
            return recordedTimestamp <= (desiredTimestamp = recorded.getLong("ts_ms", 0L));
        }
        String recordedFilename = recorded.getString("file");
        String desiredFilename = desired.getString("file");
        assert (recordedFilename != null);
        int diff = recordedFilename.compareToIgnoreCase(desiredFilename);
        if (diff > 0) {
            return false;
        }
        if (diff < 0) {
            return true;
        }
        int recordedPosition = recorded.getInteger("pos", -1);
        diff = recordedPosition - (desiredPosition = desired.getInteger("pos", -1));
        if (diff > 0) {
            return false;
        }
        if (diff < 0) {
            return true;
        }
        int recordedEventCount = recorded.getInteger("event", 0);
        diff = recordedEventCount - (desiredEventCount = desired.getInteger("event", 0));
        if (diff > 0) {
            return false;
        }
        if (diff < 0) {
            return true;
        }
        int recordedRow = recorded.getInteger("row", -1);
        diff = recordedRow - (desiredRow = desired.getInteger("row", -1));
        return diff <= 0;
    }
}

