/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import java.time.Instant;
import java.util.Map;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlOffsetContext;
import shaded.adbmysql.io.debezium.pipeline.source.spi.EventMetadataProvider;
import shaded.adbmysql.io.debezium.pipeline.spi.OffsetContext;
import shaded.adbmysql.io.debezium.schema.DataCollectionId;
import shaded.adbmysql.io.debezium.util.Collect;

class MySqlEventMetadataProvider
implements EventMetadataProvider {
    MySqlEventMetadataProvider() {
    }

    @Override
    public Instant getEventTimestamp(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        Long timestamp = sourceInfo.getInt64("ts_ms");
        return timestamp == null ? null : Instant.ofEpochMilli(timestamp);
    }

    @Override
    public Map<String, String> getEventSourcePosition(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        return Collect.hashMapOf("file", sourceInfo.getString("file"), "pos", Long.toString(sourceInfo.getInt64("pos")), "row", Integer.toString(sourceInfo.getInt32("row")));
    }

    @Override
    public String getTransactionId(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        return ((MySqlOffsetContext)offset).getTransactionId();
    }
}

