/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql;

import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.network.ServerException;
import java.io.EOFException;
import java.sql.SQLException;
import shaded.adbmysql.io.debezium.DebeziumException;
import shaded.adbmysql.io.debezium.connector.base.ChangeEventQueue;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlConnector;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlConnectorConfig;
import shaded.adbmysql.io.debezium.pipeline.ErrorHandler;

public class MySqlErrorHandler
extends ErrorHandler {
    private static final String SQL_CODE_TOO_MANY_CONNECTIONS = "08004";

    public MySqlErrorHandler(MySqlConnectorConfig connectorConfig, ChangeEventQueue<?> queue) {
        super(MySqlConnector.class, connectorConfig, queue);
    }

    @Override
    protected boolean isRetriable(Throwable throwable) {
        if (throwable instanceof SQLException) {
            SQLException sql = (SQLException)throwable;
            return SQL_CODE_TOO_MANY_CONNECTIONS.equals(sql.getSQLState());
        }
        if (throwable instanceof ServerException) {
            ServerException sql = (ServerException)throwable;
            return SQL_CODE_TOO_MANY_CONNECTIONS.equals(sql.getSqlState());
        }
        if (throwable instanceof EOFException) {
            return throwable.getMessage().contains("Failed to read next byte from position");
        }
        if (throwable instanceof DebeziumException && throwable.getCause() != null) {
            return this.isRetriable(throwable.getCause());
        }
        return false;
    }
}

