/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigValue;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.Task;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.adbmysql.io.debezium.annotation.Immutable;
import shaded.adbmysql.io.debezium.config.Configuration;
import shaded.adbmysql.io.debezium.connector.common.RelationalBaseSourceConnector;
import shaded.adbmysql.io.debezium.connector.mysql.Module;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlConnection;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlConnectorConfig;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlConnectorTask;
import shaded.adbmysql.io.debezium.relational.RelationalDatabaseConnectorConfig;

public class MySqlConnector
extends RelationalBaseSourceConnector {
    public static final String IMPLEMENTATION_PROP = "internal.implementation";
    public static final String LEGACY_IMPLEMENTATION = "legacy";
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlConnector.class);
    @Immutable
    private Map<String, String> properties;

    @Override
    public String version() {
        return Module.version();
    }

    @Override
    public void start(Map<String, String> props) {
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(props));
    }

    @Override
    public Class<? extends Task> taskClass() {
        String implementation = this.properties.get(IMPLEMENTATION_PROP);
        if (MySqlConnector.isLegacy(implementation)) {
            LOGGER.warn("Legacy MySQL connector implementation is enabled");
            return shaded.adbmysql.io.debezium.connector.mysql.legacy.MySqlConnectorTask.class;
        }
        return MySqlConnectorTask.class;
    }

    static boolean isLegacy(String implementation) {
        return LEGACY_IMPLEMENTATION.equals(implementation);
    }

    @Override
    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (maxTasks > 1) {
            throw new IllegalArgumentException("Only a single connector task may be started");
        }
        return Collections.singletonList(this.properties);
    }

    @Override
    public void stop() {
    }

    @Override
    public ConfigDef config() {
        return MySqlConnectorConfig.configDef();
    }

    @Override
    protected void validateConnection(Map<String, ConfigValue> configValues, Configuration config) {
        ConfigValue hostnameValue = configValues.get(RelationalDatabaseConnectorConfig.HOSTNAME.name());
        MySqlConnection.MySqlConnectionConfiguration connectionConfig = new MySqlConnection.MySqlConnectionConfiguration(config);
        try (MySqlConnection connection = new MySqlConnection(connectionConfig);){
            try {
                connection.connect();
                connection.execute("SELECT version()");
                LOGGER.info("Successfully tested connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connectionConfig.username());
            }
            catch (SQLException e) {
                LOGGER.error("Failed testing connection for {} with user '{}'", new Object[]{connection.connectionString(), connectionConfig.username(), e});
                hostnameValue.addErrorMessage("Unable to connect: " + e.getMessage());
            }
        }
        catch (SQLException e) {
            LOGGER.error("Unexpected error shutting down the database connection", (Throwable)e);
        }
    }

    @Override
    protected Map<String, ConfigValue> validateAllFields(Configuration config) {
        return config.validate(MySqlConnectorConfig.ALL_FIELDS);
    }
}

