/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import java.util.Optional;
import java.util.function.Function;
import shaded.adbmysql.io.debezium.connector.base.ChangeEventQueue;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlConnection;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlConnectorConfig;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlDatabaseSchema;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlOffsetContext;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlPartition;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlReadOnlyIncrementalSnapshotChangeEventSource;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlSnapshotChangeEventSource;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlSnapshotChangeEventSourceMetrics;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlStreamingChangeEventSource;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlTaskContext;
import shaded.adbmysql.io.debezium.jdbc.JdbcConnection;
import shaded.adbmysql.io.debezium.pipeline.DataChangeEvent;
import shaded.adbmysql.io.debezium.pipeline.ErrorHandler;
import shaded.adbmysql.io.debezium.pipeline.EventDispatcher;
import shaded.adbmysql.io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import shaded.adbmysql.io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotChangeEventSource;
import shaded.adbmysql.io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import shaded.adbmysql.io.debezium.pipeline.source.spi.DataChangeEventListener;
import shaded.adbmysql.io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import shaded.adbmysql.io.debezium.pipeline.source.spi.SnapshotProgressListener;
import shaded.adbmysql.io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import shaded.adbmysql.io.debezium.relational.RelationalDatabaseConnectorConfig;
import shaded.adbmysql.io.debezium.relational.TableId;
import shaded.adbmysql.io.debezium.schema.DataCollectionId;
import shaded.adbmysql.io.debezium.schema.DatabaseSchema;
import shaded.adbmysql.io.debezium.util.Clock;
import shaded.adbmysql.io.debezium.util.Strings;

public class MySqlChangeEventSourceFactory
implements ChangeEventSourceFactory<MySqlPartition, MySqlOffsetContext> {
    private final MySqlConnectorConfig configuration;
    private final MySqlConnection connection;
    private final ErrorHandler errorHandler;
    private final EventDispatcher<MySqlPartition, TableId> dispatcher;
    private final Clock clock;
    private final MySqlTaskContext taskContext;
    private final MySqlStreamingChangeEventSourceMetrics streamingMetrics;
    private final MySqlDatabaseSchema schema;
    private final ChangeEventQueue<DataChangeEvent> queue;

    public MySqlChangeEventSourceFactory(MySqlConnectorConfig configuration, MySqlConnection connection, ErrorHandler errorHandler, EventDispatcher<MySqlPartition, TableId> dispatcher, Clock clock, MySqlDatabaseSchema schema, MySqlTaskContext taskContext, MySqlStreamingChangeEventSourceMetrics streamingMetrics, ChangeEventQueue<DataChangeEvent> queue) {
        this.configuration = configuration;
        this.connection = connection;
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.taskContext = taskContext;
        this.streamingMetrics = streamingMetrics;
        this.queue = queue;
        this.schema = schema;
    }

    @Override
    public SnapshotChangeEventSource<MySqlPartition, MySqlOffsetContext> getSnapshotChangeEventSource(SnapshotProgressListener<MySqlPartition> snapshotProgressListener) {
        return new MySqlSnapshotChangeEventSource(this.configuration, this.connection, this.taskContext.getSchema(), this.dispatcher, this.clock, (MySqlSnapshotChangeEventSourceMetrics)snapshotProgressListener, this::modifyAndFlushLastRecord);
    }

    private void modifyAndFlushLastRecord(Function<SourceRecord, SourceRecord> modify) throws InterruptedException {
        this.queue.flushBuffer(dataChange -> new DataChangeEvent((SourceRecord)modify.apply(dataChange.getRecord())));
        this.queue.disableBuffering();
    }

    @Override
    public StreamingChangeEventSource<MySqlPartition, MySqlOffsetContext> getStreamingChangeEventSource() {
        this.queue.disableBuffering();
        return new MySqlStreamingChangeEventSource(this.configuration, this.connection, this.dispatcher, this.errorHandler, this.clock, this.taskContext, this.streamingMetrics);
    }

    @Override
    public Optional<IncrementalSnapshotChangeEventSource<MySqlPartition, ? extends DataCollectionId>> getIncrementalSnapshotChangeEventSource(MySqlOffsetContext offsetContext, SnapshotProgressListener<MySqlPartition> snapshotProgressListener, DataChangeEventListener<MySqlPartition> dataChangeEventListener) {
        if (this.configuration.isReadOnlyConnection()) {
            if (this.connection.isGtidModeEnabled()) {
                return Optional.of(new MySqlReadOnlyIncrementalSnapshotChangeEventSource<TableId>((RelationalDatabaseConnectorConfig)this.configuration, (JdbcConnection)this.connection, this.dispatcher, (DatabaseSchema<?>)this.schema, this.clock, snapshotProgressListener, dataChangeEventListener));
            }
            throw new UnsupportedOperationException("Read only connection requires GTID_MODE to be ON");
        }
        if (Strings.isNullOrEmpty(this.configuration.getSignalingDataCollectionId())) {
            return Optional.empty();
        }
        return Optional.of(new SignalBasedIncrementalSnapshotChangeEventSource<MySqlPartition, TableId>(this.configuration, this.connection, this.dispatcher, this.schema, this.clock, snapshotProgressListener, dataChangeEventListener));
    }
}

