/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.mysql;

import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.GtidSet;
import java.util.ArrayList;
import java.util.HashMap;
import shaded.adbmysql.io.debezium.connector.mysql.GtidSet;

public class GtidUtils {
    public static GtidSet fixRestoredGtidSet(GtidSet serverGtidSet, GtidSet restoredGtidSet) {
        HashMap<String, GtidSet.UUIDSet> newSet = new HashMap<String, GtidSet.UUIDSet>();
        serverGtidSet.getUUIDSets().forEach(uuidSet -> newSet.put(uuidSet.getUUID(), (GtidSet.UUIDSet)uuidSet));
        for (GtidSet.UUIDSet uuidSet2 : restoredGtidSet.getUUIDSets()) {
            GtidSet.UUIDSet serverUuidSet = (GtidSet.UUIDSet)newSet.get(uuidSet2.getUUID());
            if (serverUuidSet != null) {
                long restoredIntervalEnd = GtidUtils.getIntervalEnd(uuidSet2);
                ArrayList<GtidSet.Interval> newIntervals = new ArrayList<GtidSet.Interval>();
                for (GtidSet.Interval serverInterval : serverUuidSet.getIntervals()) {
                    if (serverInterval.getEnd() <= restoredIntervalEnd) {
                        newIntervals.add(new GtidSet.Interval(serverInterval.getStart(), serverInterval.getEnd()));
                        continue;
                    }
                    if (serverInterval.getStart() > restoredIntervalEnd || serverInterval.getEnd() <= restoredIntervalEnd) continue;
                    newIntervals.add(new GtidSet.Interval(serverInterval.getStart(), restoredIntervalEnd));
                }
                newSet.put(uuidSet2.getUUID(), new GtidSet.UUIDSet(new GtidSet.UUIDSet(uuidSet2.getUUID(), newIntervals)));
                continue;
            }
            newSet.put(uuidSet2.getUUID(), uuidSet2);
        }
        return new GtidSet(newSet);
    }

    public static GtidSet mergeGtidSetInto(GtidSet base, GtidSet toMerge) {
        HashMap<String, GtidSet.UUIDSet> newSet = new HashMap<String, GtidSet.UUIDSet>();
        base.getUUIDSets().forEach(uuidSet -> newSet.put(uuidSet.getUUID(), (GtidSet.UUIDSet)uuidSet));
        for (GtidSet.UUIDSet uuidSet2 : toMerge.getUUIDSets()) {
            if (newSet.containsKey(uuidSet2.getUUID())) continue;
            newSet.put(uuidSet2.getUUID(), uuidSet2);
        }
        return new GtidSet(newSet);
    }

    private static long getIntervalEnd(GtidSet.UUIDSet uuidSet) {
        return uuidSet.getIntervals().stream().mapToLong(GtidSet.Interval::getEnd).max().getAsLong();
    }
}

