/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.connector.common;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.OffsetStorageReader;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import shaded.adbmysql.io.debezium.pipeline.spi.OffsetContext;
import shaded.adbmysql.io.debezium.pipeline.spi.Partition;

public class OffsetReader<P extends Partition, O extends OffsetContext, L extends OffsetContext.Loader<O>> {
    private final OffsetStorageReader reader;
    private final L loader;

    public OffsetReader(OffsetStorageReader reader, L loader) {
        this.reader = reader;
        this.loader = loader;
    }

    public Map<P, O> offsets(Set<P> partitions) {
        Set sourcePartitions = partitions.stream().map(Partition::getSourcePartition).collect(Collectors.toCollection(HashSet::new));
        Map sourceOffsets = this.reader.offsets(sourcePartitions);
        LinkedHashMap offsets = new LinkedHashMap();
        partitions.forEach(partition -> {
            Map<String, String> sourcePartition = partition.getSourcePartition();
            Map sourceOffset = (Map)sourceOffsets.get(sourcePartition);
            Object offset = null;
            if (sourceOffset != null) {
                offset = this.loader.load(sourceOffset);
            }
            offsets.put(partition, offset);
        });
        return offsets;
    }
}

