/*
 * Decompiled with CFR 0.152.
 */
package shaded.adbmysql.io.debezium.config;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.function.Supplier;
import shaded.adbmysql.io.debezium.config.Configuration;

public class Instantiator {
    public static <T> T getInstance(String className, Supplier<ClassLoader> classloaderSupplier, Configuration configuration) {
        return Instantiator.getInstanceWithProvidedConstructorType(className, classloaderSupplier, Configuration.class, configuration);
    }

    public static <T> T getInstanceWithProperties(String className, Supplier<ClassLoader> classloaderSupplier, Properties prop) {
        return Instantiator.getInstanceWithProvidedConstructorType(className, classloaderSupplier, Properties.class, prop);
    }

    public static <T, C> T getInstanceWithProvidedConstructorType(String className, Supplier<ClassLoader> classloaderSupplier, Class<C> constructorType, C constructorValue) {
        if (className != null) {
            ClassLoader classloader = classloaderSupplier != null ? classloaderSupplier.get() : Configuration.class.getClassLoader();
            try {
                Class<?> clazz = classloader.loadClass(className);
                return (T)(constructorValue == null ? clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : clazz.getConstructor(constructorType).newInstance(constructorValue));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unable to find class " + className, e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Unable to instantiate class " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to access class " + className, e);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException("Call to constructor of class " + className + " failed", e);
            }
        }
        return null;
    }
}

