/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.NodeApiVersions;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.ProduceRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ApiVersions {
    private final Map<String, NodeApiVersions> nodeApiVersions = new HashMap<String, NodeApiVersions>();
    private byte maxUsableProduceMagic = (byte)2;

    public synchronized void update(String nodeId, NodeApiVersions nodeApiVersions) {
        this.nodeApiVersions.put(nodeId, nodeApiVersions);
        this.maxUsableProduceMagic = this.computeMaxUsableProduceMagic();
    }

    public synchronized void remove(String nodeId) {
        this.nodeApiVersions.remove(nodeId);
        this.maxUsableProduceMagic = this.computeMaxUsableProduceMagic();
    }

    public synchronized NodeApiVersions get(String nodeId) {
        return this.nodeApiVersions.get(nodeId);
    }

    private byte computeMaxUsableProduceMagic() {
        Optional<Byte> knownBrokerNodesMinRequiredMagicForProduce = this.nodeApiVersions.values().stream().filter(versions -> versions.apiVersion(ApiKeys.PRODUCE) != null).map(versions -> ProduceRequest.requiredMagicForVersion(versions.latestUsableVersion(ApiKeys.PRODUCE))).min(Byte::compare);
        return (byte)Math.min(2, knownBrokerNodesMinRequiredMagicForProduce.orElse((byte)2).byteValue());
    }

    public synchronized byte maxUsableProduceMagic() {
        return this.maxUsableProduceMagic;
    }
}

