/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.network.protocol.command;

import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.io.ByteArrayOutputStream;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.network.protocol.command.Command;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.network.protocol.command.CommandType;
import java.io.IOException;

public class DumpBinaryLogCommand
implements Command {
    public static final int BINLOG_SEND_ANNOTATE_ROWS_EVENT = 2;
    private long serverId;
    private String binlogFilename;
    private long binlogPosition;
    private boolean sendAnnotateRowsEvent;

    public DumpBinaryLogCommand(long serverId, String binlogFilename, long binlogPosition) {
        this.serverId = serverId;
        this.binlogFilename = binlogFilename;
        this.binlogPosition = binlogPosition;
    }

    public DumpBinaryLogCommand(long serverId, String binlogFilename, long binlogPosition, boolean sendAnnotateRowsEvent) {
        this(serverId, binlogFilename, binlogPosition);
        this.sendAnnotateRowsEvent = sendAnnotateRowsEvent;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.writeInteger(CommandType.BINLOG_DUMP.ordinal(), 1);
        buffer.writeLong(this.binlogPosition, 4);
        int binlogFlags = 0;
        if (this.sendAnnotateRowsEvent) {
            binlogFlags |= 2;
        }
        buffer.writeInteger(binlogFlags, 2);
        buffer.writeLong(this.serverId, 4);
        buffer.writeString(this.binlogFilename);
        return buffer.toByteArray();
    }
}

