/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.jmx;

import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.Event;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.EventHeader;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.EventType;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.jmx.BinaryLogClientStatisticsMXBean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class BinaryLogClientStatistics
implements BinaryLogClientStatisticsMXBean,
BinaryLogClient.EventListener,
BinaryLogClient.LifecycleListener {
    private AtomicReference<EventHeader> lastEventHeader = new AtomicReference();
    private AtomicLong timestampOfLastEvent = new AtomicLong();
    private AtomicLong totalNumberOfEventsSeen = new AtomicLong();
    private AtomicLong totalBytesReceived = new AtomicLong();
    private AtomicLong numberOfSkippedEvents = new AtomicLong();
    private AtomicLong numberOfDisconnects = new AtomicLong();

    public BinaryLogClientStatistics() {
    }

    public BinaryLogClientStatistics(BinaryLogClient binaryLogClient) {
        binaryLogClient.registerEventListener(this);
        binaryLogClient.registerLifecycleListener(this);
    }

    @Override
    public String getLastEvent() {
        EventHeader eventHeader = this.lastEventHeader.get();
        return eventHeader == null ? null : (Object)((Object)eventHeader.getEventType()) + "/" + eventHeader.getTimestamp() + " from server " + eventHeader.getServerId();
    }

    @Override
    public long getSecondsSinceLastEvent() {
        long timestamp = this.timestampOfLastEvent.get();
        return timestamp == 0L ? 0L : (this.getCurrentTimeMillis() - timestamp) / 1000L;
    }

    @Override
    public long getSecondsBehindMaster() {
        long timestamp = this.timestampOfLastEvent.get();
        EventHeader eventHeader = this.lastEventHeader.get();
        if (timestamp == 0L || eventHeader == null) {
            return -1L;
        }
        if (eventHeader.getEventType() == EventType.HEARTBEAT && eventHeader.getTimestamp() == 0L) {
            return 0L;
        }
        return (timestamp - eventHeader.getTimestamp()) / 1000L;
    }

    @Override
    public long getTotalNumberOfEventsSeen() {
        return this.totalNumberOfEventsSeen.get();
    }

    @Override
    public long getTotalBytesReceived() {
        return this.totalBytesReceived.get();
    }

    @Override
    public long getNumberOfSkippedEvents() {
        return this.numberOfSkippedEvents.get();
    }

    @Override
    public long getNumberOfDisconnects() {
        return this.numberOfDisconnects.get();
    }

    @Override
    public void reset() {
        this.lastEventHeader.set(null);
        this.timestampOfLastEvent.set(0L);
        this.totalNumberOfEventsSeen.set(0L);
        this.totalBytesReceived.set(0L);
        this.numberOfSkippedEvents.set(0L);
        this.numberOfDisconnects.set(0L);
    }

    @Override
    public void onEvent(Event event) {
        Object header = event.getHeader();
        this.lastEventHeader.set((EventHeader)header);
        this.timestampOfLastEvent.set(this.getCurrentTimeMillis());
        this.totalNumberOfEventsSeen.getAndIncrement();
        this.totalBytesReceived.getAndAdd(header.getHeaderLength() + header.getDataLength());
    }

    @Override
    public void onEventDeserializationFailure(BinaryLogClient client, Exception ex) {
        this.numberOfSkippedEvents.getAndIncrement();
        this.lastEventHeader.set(null);
        this.timestampOfLastEvent.set(this.getCurrentTimeMillis());
        this.totalNumberOfEventsSeen.getAndIncrement();
    }

    @Override
    public void onDisconnect(BinaryLogClient client) {
        this.numberOfDisconnects.getAndIncrement();
    }

    @Override
    public void onConnect(BinaryLogClient client) {
    }

    @Override
    public void onCommunicationFailure(BinaryLogClient client, Exception ex) {
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

