/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.deserialization;

import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.TableMapEventMetadata;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.deserialization.ColumnType;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.deserialization.TableMapEventMetadataDeserializer;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;

public class TableMapEventDataDeserializer
implements EventDataDeserializer<TableMapEventData> {
    private final TableMapEventMetadataDeserializer metadataDeserializer = new TableMapEventMetadataDeserializer();

    @Override
    public TableMapEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        TableMapEventData eventData = new TableMapEventData();
        eventData.setTableId(inputStream.readLong(6));
        inputStream.skip(3L);
        eventData.setDatabase(inputStream.readZeroTerminatedString());
        inputStream.skip(1L);
        eventData.setTable(inputStream.readZeroTerminatedString());
        int numberOfColumns = inputStream.readPackedInteger();
        eventData.setColumnTypes(inputStream.read(numberOfColumns));
        inputStream.readPackedInteger();
        eventData.setColumnMetadata(this.readMetadata(inputStream, eventData.getColumnTypes()));
        eventData.setColumnNullability(inputStream.readBitSet(numberOfColumns, true));
        int metadataLength = inputStream.available();
        TableMapEventMetadata metadata = null;
        if (metadataLength > 0) {
            metadata = this.metadataDeserializer.deserialize(new ByteArrayInputStream(inputStream.read(metadataLength)), eventData.getColumnTypes().length, this.numericColumnCount(eventData.getColumnTypes()));
        }
        eventData.setEventMetadata(metadata);
        return eventData;
    }

    private int numericColumnCount(byte[] types) {
        int count = 0;
        block3: for (int i = 0; i < types.length; ++i) {
            switch (ColumnType.byCode(types[i] & 0xFF)) {
                case TINY: 
                case SHORT: 
                case INT24: 
                case LONG: 
                case LONGLONG: 
                case NEWDECIMAL: 
                case FLOAT: 
                case DOUBLE: {
                    ++count;
                    continue block3;
                }
            }
        }
        return count;
    }

    private int[] readMetadata(ByteArrayInputStream inputStream, byte[] columnTypes) throws IOException {
        int[] metadata = new int[columnTypes.length];
        block6: for (int i = 0; i < columnTypes.length; ++i) {
            ColumnType columnType = ColumnType.byCode(columnTypes[i] & 0xFF);
            if (columnType == ColumnType.TYPED_ARRAY) {
                byte[] arrayType = inputStream.read(1);
                columnType = ColumnType.byCode(arrayType[0] & 0xFF);
            }
            switch (columnType) {
                case FLOAT: 
                case DOUBLE: 
                case BLOB: 
                case JSON: 
                case GEOMETRY: {
                    metadata[i] = inputStream.readInteger(1);
                    continue block6;
                }
                case NEWDECIMAL: 
                case BIT: 
                case VARCHAR: {
                    metadata[i] = inputStream.readInteger(2);
                    continue block6;
                }
                case SET: 
                case ENUM: 
                case STRING: {
                    metadata[i] = TableMapEventDataDeserializer.bigEndianInteger(inputStream.read(2), 0, 2);
                    continue block6;
                }
                case TIME_V2: 
                case DATETIME_V2: 
                case TIMESTAMP_V2: {
                    metadata[i] = inputStream.readInteger(1);
                    continue block6;
                }
                default: {
                    metadata[i] = 0;
                }
            }
        }
        return metadata;
    }

    private static int bigEndianInteger(byte[] bytes, int offset, int length) {
        int result = 0;
        for (int i = offset; i < offset + length; ++i) {
            int b = bytes[i];
            result = result << 8 | (b >= 0 ? b : b + 256);
        }
        return result;
    }
}

