/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.deserialization;

import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.PreviousGtidSetEventData;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;

public class PreviousGtidSetDeserializer
implements EventDataDeserializer<PreviousGtidSetEventData> {
    @Override
    public PreviousGtidSetEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        int nUuids = inputStream.readInteger(8);
        String[] gtids = new String[nUuids];
        for (int i = 0; i < nUuids; ++i) {
            String uuid = this.formatUUID(inputStream.read(16));
            int nIntervals = inputStream.readInteger(8);
            String[] intervals = new String[nIntervals];
            for (int j = 0; j < nIntervals; ++j) {
                long start = inputStream.readLong(8);
                long end = inputStream.readLong(8);
                intervals[j] = start + "-" + (end - 1L);
            }
            gtids[i] = String.format("%s:%s", uuid, PreviousGtidSetDeserializer.join(intervals, ":"));
        }
        return new PreviousGtidSetEventData(PreviousGtidSetDeserializer.join(gtids, ","));
    }

    private String formatUUID(byte[] bytes) {
        return String.format("%s-%s-%s-%s-%s", PreviousGtidSetDeserializer.byteArrayToHex(bytes, 0, 4), PreviousGtidSetDeserializer.byteArrayToHex(bytes, 4, 2), PreviousGtidSetDeserializer.byteArrayToHex(bytes, 6, 2), PreviousGtidSetDeserializer.byteArrayToHex(bytes, 8, 2), PreviousGtidSetDeserializer.byteArrayToHex(bytes, 10, 6));
    }

    private static String byteArrayToHex(byte[] a, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        for (int idx = offset; idx < offset + len && idx < a.length; ++idx) {
            sb.append(String.format("%02x", a[idx] & 0xFF));
        }
        return sb.toString();
    }

    private static String join(String[] values, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(values[i]);
        }
        return sb.toString();
    }
}

