/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.deserialization;

import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;

public class GtidEventDataDeserializer
implements EventDataDeserializer<GtidEventData> {
    @Override
    public GtidEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        GtidEventData eventData = new GtidEventData();
        byte flags = (byte)inputStream.readInteger(1);
        byte[] sid = inputStream.read(16);
        long gno = inputStream.readLong(8);
        eventData.setFlags(flags);
        eventData.setGtid(this.byteArrayToHex(sid, 0, 4) + "-" + this.byteArrayToHex(sid, 4, 2) + "-" + this.byteArrayToHex(sid, 6, 2) + "-" + this.byteArrayToHex(sid, 8, 2) + "-" + this.byteArrayToHex(sid, 10, 6) + ":" + String.format("%d", gno));
        return eventData;
    }

    private String byteArrayToHex(byte[] a, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        for (int idx = offset; idx < offset + len && idx < a.length; ++idx) {
            sb.append(String.format("%02x", a[idx] & 0xFF));
        }
        return sb.toString();
    }
}

