/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.deserialization;

import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.EventType;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.FormatDescriptionEventData;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.deserialization.ChecksumType;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.ververica.cdc.connectors.shaded.com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;

public class FormatDescriptionEventDataDeserializer
implements EventDataDeserializer<FormatDescriptionEventData> {
    @Override
    public FormatDescriptionEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        int eventBodyLength = inputStream.available();
        FormatDescriptionEventData eventData = new FormatDescriptionEventData();
        eventData.setBinlogVersion(inputStream.readInteger(2));
        eventData.setServerVersion(inputStream.readString(50).trim());
        inputStream.skip(4L);
        eventData.setHeaderLength(inputStream.readInteger(1));
        inputStream.skip(EventType.FORMAT_DESCRIPTION.ordinal() - 1);
        eventData.setDataLength(inputStream.readInteger(1));
        int checksumBlockLength = eventBodyLength - eventData.getDataLength();
        ChecksumType checksumType = ChecksumType.NONE;
        if (checksumBlockLength > 0) {
            inputStream.skip(inputStream.available() - checksumBlockLength);
            checksumType = ChecksumType.byOrdinal(inputStream.read());
        }
        eventData.setChecksumType(checksumType);
        return eventData;
    }
}

