/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.analyticdb.table;

import com.ververica.cdc.connectors.analyticdb.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.analyticdb.table.StartupMode;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;

public final class StartupOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final StartupMode startupMode;
    @Nullable
    public final BinlogOffset binlogOffset;

    public static StartupOptions initial() {
        return new StartupOptions(StartupMode.INITIAL, null);
    }

    public static StartupOptions earliest() {
        return new StartupOptions(StartupMode.EARLIEST_OFFSET, BinlogOffset.ofEarliest());
    }

    public static StartupOptions latest() {
        return new StartupOptions(StartupMode.LATEST_OFFSET, BinlogOffset.ofLatest());
    }

    public static StartupOptions specificOffset(String specificOffsetFile, long specificOffsetPos) {
        return new StartupOptions(StartupMode.SPECIFIC_OFFSETS, BinlogOffset.ofBinlogFilePosition(specificOffsetFile, specificOffsetPos));
    }

    public static StartupOptions specificOffset(String gtidSet) {
        return new StartupOptions(StartupMode.SPECIFIC_OFFSETS, BinlogOffset.ofGtidSet(gtidSet));
    }

    public static StartupOptions specificOffset(BinlogOffset binlogOffset) {
        return new StartupOptions(StartupMode.SPECIFIC_OFFSETS, binlogOffset);
    }

    public static StartupOptions timestamp(long startupTimestampMillis) {
        return new StartupOptions(StartupMode.TIMESTAMP, BinlogOffset.ofTimestampSec(startupTimestampMillis / 1000L));
    }

    private StartupOptions(StartupMode startupMode, BinlogOffset binlogOffset) {
        this.startupMode = startupMode;
        this.binlogOffset = binlogOffset;
        if (startupMode != StartupMode.INITIAL) {
            Preconditions.checkNotNull((Object)binlogOffset, (String)"Binlog offset is required if startup mode is %s", (Object[])new Object[]{startupMode});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartupOptions that = (StartupOptions)o;
        return this.startupMode == that.startupMode && Objects.equals(this.binlogOffset, that.binlogOffset);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startupMode, this.binlogOffset});
    }
}

