/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.analyticdb.source.utils;

import com.ververica.cdc.connectors.analyticdb.schema.MySqlSchema;
import com.ververica.cdc.connectors.analyticdb.source.config.MySqlSourceConfig;
import com.ververica.cdc.connectors.analyticdb.source.utils.StatementUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.adbmysql.io.debezium.connector.mysql.ADBMySqlConnection;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlPartition;
import shaded.adbmysql.io.debezium.jdbc.JdbcConnection;
import shaded.adbmysql.io.debezium.relational.RelationalTableFilters;
import shaded.adbmysql.io.debezium.relational.TableId;
import shaded.adbmysql.io.debezium.relational.history.TableChanges;

public class TableDiscoveryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TableDiscoveryUtils.class);

    public static List<TableId> listTables(JdbcConnection jdbc, RelationalTableFilters tableFilters) throws SQLException {
        ArrayList<TableId> capturedTableIds = new ArrayList<TableId>();
        LOG.info("Read list of available databases");
        ArrayList databaseNames = new ArrayList();
        jdbc.query("SHOW DATABASES", rs -> {
            while (rs.next()) {
                String databaseName = rs.getString(1);
                if (!tableFilters.databaseFilter().test(databaseName)) continue;
                databaseNames.add(databaseName);
            }
        });
        LOG.info("\t list of available databases is: {}", databaseNames);
        LOG.info("Read list of available tables in each database");
        for (String dbName : databaseNames) {
            try {
                jdbc.query("SHOW FULL TABLES IN " + StatementUtils.quote(dbName) + " where Table_Type = 'BASE TABLE'", rs -> {
                    while (rs.next()) {
                        TableId tableId = new TableId(dbName, null, rs.getString(1));
                        if (tableFilters.dataCollectionFilter().isIncluded(tableId)) {
                            capturedTableIds.add(tableId);
                            LOG.info("\t including table '{}' for further processing", (Object)tableId);
                            continue;
                        }
                        LOG.info("\t '{}' is filtered out of table capturing", (Object)tableId);
                    }
                });
            }
            catch (SQLException e) {
                LOG.warn("\t skipping database '{}' due to error reading tables: {}", (Object)dbName, (Object)e.getMessage());
            }
        }
        return capturedTableIds;
    }

    public static Map<TableId, TableChanges.TableChange> discoverSchemaForCapturedTables(MySqlPartition partition, MySqlSourceConfig sourceConfig, ADBMySqlConnection jdbc) {
        List<TableId> capturedTableIds;
        try {
            capturedTableIds = TableDiscoveryUtils.listTables(jdbc, sourceConfig.getTableFilters());
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Failed to discover captured tables", (Throwable)e);
        }
        return TableDiscoveryUtils.discoverSchemaForCapturedTables(partition, capturedTableIds, sourceConfig, jdbc);
    }

    public static Map<TableId, TableChanges.TableChange> discoverSchemaForNewAddedTables(MySqlPartition partition, List<TableId> existedTables, MySqlSourceConfig sourceConfig, ADBMySqlConnection jdbc) {
        List<TableId> capturedTableIds;
        try {
            capturedTableIds = TableDiscoveryUtils.listTables(jdbc, sourceConfig.getTableFilters()).stream().filter(tableId -> !existedTables.contains(tableId)).collect(Collectors.toList());
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Failed to discover captured tables", (Throwable)e);
        }
        return capturedTableIds.isEmpty() ? new HashMap<TableId, TableChanges.TableChange>() : TableDiscoveryUtils.discoverSchemaForCapturedTables(partition, capturedTableIds, sourceConfig, jdbc);
    }

    public static Map<TableId, TableChanges.TableChange> discoverSchemaForCapturedTables(MySqlPartition partition, List<TableId> capturedTableIds, MySqlSourceConfig sourceConfig, ADBMySqlConnection jdbc) {
        if (capturedTableIds.isEmpty()) {
            throw new IllegalArgumentException(String.format("Can't find any matched tables, please check your configured database-name: %s and table-name: %s", sourceConfig.getDatabaseList(), sourceConfig.getTableList()));
        }
        try (MySqlSchema mySqlSchema = new MySqlSchema(sourceConfig, jdbc.isTableIdCaseSensitive());){
            HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
            for (TableId tableId : capturedTableIds) {
                TableChanges.TableChange tableSchema = mySqlSchema.getTableSchema(partition, jdbc, tableId);
                tableSchemas.put(tableId, tableSchema);
            }
            HashMap<TableId, TableChanges.TableChange> hashMap = tableSchemas;
            return hashMap;
        }
    }
}

