/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.analyticdb.source.utils;

import com.ververica.cdc.connectors.analyticdb.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.analyticdb.source.offset.BinlogOffsetKind;
import com.ververica.cdc.connectors.analyticdb.source.offset.BinlogOffsetSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;

public class SerializerUtils {
    private SerializerUtils() {
    }

    public static void writeBinlogPosition(BinlogOffset offset, DataOutputSerializer out) throws IOException {
        out.writeBoolean(offset != null);
        if (offset != null) {
            byte[] binlogOffsetBytes = BinlogOffsetSerializer.INSTANCE.serialize(offset);
            out.writeInt(binlogOffsetBytes.length);
            out.write(binlogOffsetBytes);
        }
    }

    public static BinlogOffset readBinlogPosition(int offsetVersion, DataInputDeserializer in) throws IOException {
        switch (offsetVersion) {
            case 1: {
                return in.readBoolean() ? BinlogOffset.ofBinlogFilePosition(in.readUTF(), in.readLong()) : null;
            }
            case 2: 
            case 3: 
            case 4: {
                return SerializerUtils.readBinlogPosition(in);
            }
        }
        throw new IOException("Unknown version: " + offsetVersion);
    }

    public static BinlogOffset readBinlogPosition(DataInputDeserializer in) throws IOException {
        boolean offsetNonNull = in.readBoolean();
        if (offsetNonNull) {
            int binlogOffsetBytesLength = in.readInt();
            byte[] binlogOffsetBytes = new byte[binlogOffsetBytesLength];
            in.readFully(binlogOffsetBytes);
            BinlogOffset offset = BinlogOffsetSerializer.INSTANCE.deserialize(binlogOffsetBytes);
            if (offset.getOffsetKind() == null) {
                if (StringUtils.isEmpty((CharSequence)offset.getFilename()) && offset.getPosition() == Long.MIN_VALUE) {
                    return BinlogOffset.ofNonStopping();
                }
                if (StringUtils.isEmpty((CharSequence)offset.getFilename()) && offset.getPosition() == 0L) {
                    return BinlogOffset.ofEarliest();
                }
                return BinlogOffset.builder().setOffsetKind(BinlogOffsetKind.SPECIFIC).setOffsetMap(offset.getOffset()).build();
            }
            return offset;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static String rowToSerializedString(Object[] splitBoundary) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Object[] serializedStringToRow(String serialized) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

