/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.analyticdb.source.utils;

import com.ververica.cdc.connectors.analyticdb.source.utils.VersionComparable;
import org.apache.flink.runtime.util.EnvironmentInformation;

public class EnvironmentUtils {
    private static final VersionComparable FLINK_1_14 = VersionComparable.fromVersionString("1.14");

    private EnvironmentUtils() {
    }

    public static VersionComparable runtimeFlinkVersion() {
        return VersionComparable.fromVersionString(EnvironmentInformation.getVersion());
    }

    public static boolean supportCheckpointsAfterTasksFinished() {
        return EnvironmentUtils.runtimeFlinkVersion().newerThanOrEqualTo(FLINK_1_14);
    }

    public static void checkSupportCheckpointsAfterTasksFinished(boolean closeIdleReaders) {
        if (closeIdleReaders && !EnvironmentUtils.supportCheckpointsAfterTasksFinished()) {
            throw new UnsupportedOperationException("The flink version is required to be greater than or equal to 1.14 when 'execution.checkpointing.checkpoints-after-tasks-finish.enabled' is set to true. But the current version is " + EnvironmentUtils.runtimeFlinkVersion());
        }
    }
}

