/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.analyticdb.source.split;

import com.ververica.cdc.connectors.analyticdb.source.split.SourceRecords;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;

public final class MySqlRecords
implements RecordsWithSplitIds<SourceRecords> {
    @Nullable
    private String splitId;
    @Nullable
    private Iterator<SourceRecords> recordsForCurrentSplit;
    @Nullable
    private final Iterator<SourceRecords> recordsForSplit;
    private final Set<String> finishedSnapshotSplits;

    public MySqlRecords(@Nullable String splitId, @Nullable Iterator<SourceRecords> recordsForSplit, Set<String> finishedSnapshotSplits) {
        this.splitId = splitId;
        this.recordsForSplit = recordsForSplit;
        this.finishedSnapshotSplits = finishedSnapshotSplits;
    }

    @Nullable
    public String nextSplit() {
        String nextSplit = this.splitId;
        this.splitId = null;
        this.recordsForCurrentSplit = nextSplit != null ? this.recordsForSplit : null;
        return nextSplit;
    }

    @Nullable
    public SourceRecords nextRecordFromSplit() {
        Iterator<SourceRecords> recordsForSplit = this.recordsForCurrentSplit;
        if (recordsForSplit != null) {
            if (recordsForSplit.hasNext()) {
                return recordsForSplit.next();
            }
            return null;
        }
        throw new IllegalStateException();
    }

    public Set<String> finishedSplits() {
        return this.finishedSnapshotSplits;
    }

    public static MySqlRecords forBinlogRecords(String splitId, Iterator<SourceRecords> recordsForSplit) {
        return new MySqlRecords(splitId, recordsForSplit, Collections.emptySet());
    }

    public static MySqlRecords forSnapshotRecords(String splitId, Iterator<SourceRecords> recordsForSplit) {
        return new MySqlRecords(splitId, recordsForSplit, Collections.singleton(splitId));
    }

    public static MySqlRecords forFinishedSplit(String splitId) {
        return new MySqlRecords(null, null, Collections.singleton(splitId));
    }
}

