/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.analyticdb.source.offset;

import com.ververica.cdc.connectors.analyticdb.debezium.DebeziumUtils;
import com.ververica.cdc.connectors.analyticdb.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.analyticdb.source.offset.BinlogOffsetKind;
import shaded.adbmysql.io.debezium.connector.mysql.ADBMySqlConnection;
import shaded.adbmysql.io.debezium.relational.TableId;

public class BinlogOffsetUtils {
    public static BinlogOffset initializeEffectiveOffset(BinlogOffset offset, ADBMySqlConnection connection, TableId tableId) {
        BinlogOffsetKind offsetKind = offset.getOffsetKind();
        switch (offsetKind) {
            case EARLIEST: 
            case TIMESTAMP: {
                BinlogOffset currentBinlogOffset = DebeziumUtils.currentBinlogOffset(connection, tableId, "");
                return BinlogOffset.ofBinlogFilePosition(BinlogOffsetUtils.formatBinlogString(currentBinlogOffset.getFilename()), 0L);
            }
            case LATEST: {
                return DebeziumUtils.currentBinlogOffset(connection, tableId, "");
            }
        }
        return offset;
    }

    private static String formatBinlogString(String binlogFileName) {
        String[] binlogNumber = binlogFileName.split("\\.");
        if (binlogNumber.length != 2) {
            throw new IllegalArgumentException("Invalid binlog file name" + binlogFileName);
        }
        return String.format("%s.000000", binlogNumber[0]);
    }

    public static boolean isNonStoppingOffset(BinlogOffset binlogOffset) {
        return BinlogOffsetKind.NON_STOPPING.equals((Object)binlogOffset.getOffsetKind());
    }
}

