/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.analyticdb.source.connection;

import com.ververica.cdc.connectors.analyticdb.source.config.MySqlSourceConfig;
import com.ververica.cdc.connectors.analyticdb.source.connection.ConnectionPoolId;
import com.ververica.cdc.connectors.analyticdb.source.connection.JdbcConnectionPools;
import com.ververica.cdc.connectors.shaded.com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.adbmysql.io.debezium.jdbc.JdbcConfiguration;
import shaded.adbmysql.io.debezium.jdbc.JdbcConnection;

public class JdbcConnectionFactory
implements JdbcConnection.ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcConnectionFactory.class);
    private final MySqlSourceConfig sourceConfig;

    public JdbcConnectionFactory(MySqlSourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    @Override
    public Connection connect(JdbcConfiguration config) throws SQLException {
        int connectRetryTimes = this.sourceConfig.getConnectMaxRetries();
        ConnectionPoolId connectionPoolId = new ConnectionPoolId(this.sourceConfig.getHostname(), this.sourceConfig.getPort(), this.sourceConfig.getUsername());
        HikariDataSource dataSource = JdbcConnectionPools.getInstance().getOrCreateConnectionPool(connectionPoolId, this.sourceConfig);
        for (int i = 0; i < connectRetryTimes; ++i) {
            try {
                return dataSource.getConnection();
            }
            catch (SQLException e) {
                if (i < connectRetryTimes - 1) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException ie) {
                        throw new FlinkRuntimeException("Failed to get connection, interrupted while doing another attempt", (Throwable)ie);
                    }
                } else {
                    LOG.error("Get connection failed after retry {} times", (Object)(i + 1));
                    throw new FlinkRuntimeException((Throwable)e);
                }
                LOG.warn("Get connection failed, retry times {}", (Object)(i + 1));
                continue;
            }
        }
        return dataSource.getConnection();
    }
}

