/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.analyticdb.source.assigners.state;

import java.util.Objects;
import javax.annotation.Nullable;
import shaded.adbmysql.io.debezium.relational.TableId;

public class ChunkSplitterState {
    public static final ChunkSplitterState NO_SPLITTING_TABLE_STATE = new ChunkSplitterState(null, null, null);
    @Nullable
    private final TableId currentSplittingTableId;
    @Nullable
    private final ChunkBound nextChunkStart;
    @Nullable
    private final Integer nextChunkId;

    public ChunkSplitterState(@Nullable TableId currentSplittingTableId, @Nullable ChunkBound nextChunkStart, @Nullable Integer nextChunkId) {
        this.currentSplittingTableId = currentSplittingTableId;
        this.nextChunkStart = nextChunkStart;
        this.nextChunkId = nextChunkId;
    }

    @Nullable
    public TableId getCurrentSplittingTableId() {
        return this.currentSplittingTableId;
    }

    @Nullable
    public ChunkBound getNextChunkStart() {
        return this.nextChunkStart;
    }

    @Nullable
    public Integer getNextChunkId() {
        return this.nextChunkId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChunkSplitterState)) {
            return false;
        }
        ChunkSplitterState that = (ChunkSplitterState)o;
        return Objects.equals(this.currentSplittingTableId, that.currentSplittingTableId) && Objects.equals(this.nextChunkStart, that.nextChunkStart) && Objects.equals(this.nextChunkId, that.nextChunkId);
    }

    public int hashCode() {
        return Objects.hash(this.currentSplittingTableId, this.nextChunkStart, this.nextChunkId);
    }

    public String toString() {
        return "ChunkSplitterState{currentSplittingTableId=" + (this.currentSplittingTableId == null ? "null" : this.currentSplittingTableId) + ", nextChunkStart=" + (this.nextChunkStart == null ? "null" : this.nextChunkStart) + ", nextChunkId=" + (this.nextChunkId == null ? "null" : String.valueOf(this.nextChunkId)) + '}';
    }

    public static enum ChunkBoundType {
        START,
        MIDDLE,
        END;

    }

    public static final class ChunkBound {
        public static final ChunkBound START_BOUND = new ChunkBound(ChunkBoundType.START, null);
        public static final ChunkBound END_BOUND = new ChunkBound(ChunkBoundType.END, null);
        private final ChunkBoundType boundType;
        @Nullable
        private final Object value;

        public ChunkBound(ChunkBoundType boundType, @Nullable Object value) {
            this.boundType = boundType;
            this.value = value;
        }

        public ChunkBoundType getBoundType() {
            return this.boundType;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        public static ChunkBound middleOf(Object obj) {
            return new ChunkBound(ChunkBoundType.MIDDLE, obj);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ChunkBound)) {
                return false;
            }
            ChunkBound that = (ChunkBound)o;
            return this.boundType == that.boundType && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.boundType, this.value});
        }

        public String toString() {
            return "ChunkBound{boundType=" + (Object)((Object)this.boundType) + ", value=" + (this.value == null ? "null" : this.value.toString()) + '}';
        }
    }
}

