/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.analyticdb.schema;

import com.ververica.cdc.connectors.analyticdb.schema.MySqlFieldDefinition;
import com.ververica.cdc.connectors.analyticdb.source.utils.StatementUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.util.CollectionUtil;
import shaded.adbmysql.io.debezium.relational.TableId;

public class MySqlTableDefinition {
    TableId tableId;
    List<MySqlFieldDefinition> fieldDefinitions;
    List<String> primaryKeys;

    public MySqlTableDefinition(TableId tableId, List<MySqlFieldDefinition> fieldDefinitions, List<String> primaryKeys) {
        this.tableId = tableId;
        this.fieldDefinitions = fieldDefinitions;
        this.primaryKeys = primaryKeys;
    }

    String toDdl() {
        return String.format("CREATE TABLE %s (\n\t %s %s );", StatementUtils.quote(this.tableId), this.fieldDefinitions(), this.pkDefinition());
    }

    private String fieldDefinitions() {
        return this.fieldDefinitions.stream().map(MySqlFieldDefinition::toDdl).collect(Collectors.joining(", \n\t"));
    }

    private String pkDefinition() {
        StringBuilder pkDefinition = new StringBuilder();
        if (!CollectionUtil.isNullOrEmpty(this.primaryKeys)) {
            pkDefinition.append(",");
            pkDefinition.append(String.format("PRIMARY KEY ( %s )", this.primaryKeys.stream().map(StatementUtils::quote).collect(Collectors.joining(","))));
        }
        return pkDefinition.toString();
    }
}

