/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.analyticdb.debezium.task;

import com.ververica.cdc.connectors.analyticdb.debezium.DebeziumUtils;
import com.ververica.cdc.connectors.analyticdb.debezium.dispatcher.EventDispatcherImpl;
import com.ververica.cdc.connectors.analyticdb.debezium.dispatcher.SignalEventDispatcher;
import com.ververica.cdc.connectors.analyticdb.debezium.reader.SnapshotSplitReader;
import com.ververica.cdc.connectors.analyticdb.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.analyticdb.source.split.MySqlSnapshotSplit;
import com.ververica.cdc.connectors.analyticdb.source.utils.StatementUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.adbmysql.io.debezium.DebeziumException;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlConnectorConfig;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlDatabaseSchema;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlOffsetContext;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlPartition;
import shaded.adbmysql.io.debezium.connector.mysql.MySqlValueConverters;
import shaded.adbmysql.io.debezium.jdbc.JdbcConnection;
import shaded.adbmysql.io.debezium.pipeline.EventDispatcher;
import shaded.adbmysql.io.debezium.pipeline.metrics.SnapshotChangeEventSourceMetrics;
import shaded.adbmysql.io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import shaded.adbmysql.io.debezium.pipeline.source.spi.ChangeEventSource;
import shaded.adbmysql.io.debezium.pipeline.spi.ChangeRecordEmitter;
import shaded.adbmysql.io.debezium.pipeline.spi.Partition;
import shaded.adbmysql.io.debezium.pipeline.spi.SnapshotResult;
import shaded.adbmysql.io.debezium.relational.Column;
import shaded.adbmysql.io.debezium.relational.RelationalSnapshotChangeEventSource;
import shaded.adbmysql.io.debezium.relational.SnapshotChangeRecordEmitter;
import shaded.adbmysql.io.debezium.relational.Table;
import shaded.adbmysql.io.debezium.relational.TableId;
import shaded.adbmysql.io.debezium.schema.TopicSelector;
import shaded.adbmysql.io.debezium.util.Clock;
import shaded.adbmysql.io.debezium.util.ColumnUtils;
import shaded.adbmysql.io.debezium.util.Strings;
import shaded.adbmysql.io.debezium.util.Threads;

public class MySqlSnapshotSplitReadTask
extends AbstractSnapshotChangeEventSource<MySqlPartition, MySqlOffsetContext> {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlSnapshotSplitReadTask.class);
    private static final Duration LOG_INTERVAL = Duration.ofMillis(10000L);
    private final MySqlConnectorConfig connectorConfig;
    private final MySqlDatabaseSchema databaseSchema;
    private final JdbcConnection jdbcConnection;
    private final EventDispatcherImpl<TableId> dispatcher;
    private final Clock clock;
    private final MySqlSnapshotSplit snapshotSplit;
    private final TopicSelector<TableId> topicSelector;
    private final EventDispatcher.SnapshotReceiver<MySqlPartition> snapshotReceiver;
    private final SnapshotChangeEventSourceMetrics<MySqlPartition> snapshotChangeEventSourceMetrics;

    public MySqlSnapshotSplitReadTask(MySqlConnectorConfig connectorConfig, SnapshotChangeEventSourceMetrics<MySqlPartition> snapshotChangeEventSourceMetrics, MySqlDatabaseSchema databaseSchema, JdbcConnection jdbcConnection, EventDispatcherImpl<TableId> dispatcher, TopicSelector<TableId> topicSelector, EventDispatcher.SnapshotReceiver<MySqlPartition> snapshotReceiver, Clock clock, MySqlSnapshotSplit snapshotSplit) {
        super(connectorConfig, snapshotChangeEventSourceMetrics);
        this.connectorConfig = connectorConfig;
        this.databaseSchema = databaseSchema;
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.snapshotSplit = snapshotSplit;
        this.topicSelector = topicSelector;
        this.snapshotReceiver = snapshotReceiver;
        this.snapshotChangeEventSourceMetrics = snapshotChangeEventSourceMetrics;
    }

    @Override
    public SnapshotResult<MySqlOffsetContext> execute(ChangeEventSource.ChangeEventSourceContext context, MySqlPartition partition, MySqlOffsetContext previousOffset) throws InterruptedException {
        MySqlSnapshotContext ctx;
        AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask = this.getSnapshottingTask(partition, previousOffset);
        try {
            ctx = this.prepare(partition);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize snapshot context.", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            return this.doExecute(context, previousOffset, (AbstractSnapshotChangeEventSource.SnapshotContext<MySqlPartition, MySqlOffsetContext>)ctx, snapshottingTask);
        }
        catch (InterruptedException e) {
            LOG.warn("Snapshot was interrupted before completion");
            throw e;
        }
        catch (Exception t) {
            throw new DebeziumException(t);
        }
    }

    @Override
    protected SnapshotResult<MySqlOffsetContext> doExecute(ChangeEventSource.ChangeEventSourceContext context, MySqlOffsetContext previousOffset, AbstractSnapshotChangeEventSource.SnapshotContext<MySqlPartition, MySqlOffsetContext> snapshotContext, AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask) throws Exception {
        MySqlSnapshotContext ctx = (MySqlSnapshotContext)snapshotContext;
        ctx.offset = previousOffset;
        SignalEventDispatcher signalEventDispatcher = new SignalEventDispatcher(previousOffset.getOffset(), this.topicSelector.topicNameFor(this.snapshotSplit.getTableId()), this.dispatcher.getQueue());
        BinlogOffset lowWatermark = DebeziumUtils.currentBinlogOffset(this.jdbcConnection, this.snapshotSplit.getTableId(), "");
        LOG.info("Snapshot step 1 - Determining low watermark {} for split {}", (Object)lowWatermark, (Object)this.snapshotSplit);
        ((SnapshotSplitReader.SnapshotSplitChangeEventSourceContextImpl)context).setLowWatermark(lowWatermark);
        signalEventDispatcher.dispatchWatermarkEvent(this.snapshotSplit, lowWatermark, SignalEventDispatcher.WatermarkKind.LOW);
        LOG.info("Snapshot step 2 - Snapshotting data");
        this.createDataEvents(ctx, this.snapshotSplit.getTableId());
        BinlogOffset highWatermark = DebeziumUtils.currentBinlogOffset(this.jdbcConnection, this.snapshotSplit.getTableId(), "/* high_watermark */");
        LOG.info("Snapshot step 3 - Determining high watermark {} for split {}", (Object)highWatermark, (Object)this.snapshotSplit);
        signalEventDispatcher.dispatchWatermarkEvent(this.snapshotSplit, highWatermark, SignalEventDispatcher.WatermarkKind.HIGH);
        ((SnapshotSplitReader.SnapshotSplitChangeEventSourceContextImpl)context).setHighWatermark(highWatermark);
        return SnapshotResult.completed(ctx.offset);
    }

    @Override
    protected AbstractSnapshotChangeEventSource.SnapshottingTask getSnapshottingTask(MySqlPartition partition, MySqlOffsetContext previousOffset) {
        return new AbstractSnapshotChangeEventSource.SnapshottingTask(false, true);
    }

    protected MySqlSnapshotContext prepare(MySqlPartition partition) throws Exception {
        return new MySqlSnapshotContext(partition);
    }

    private void createDataEvents(MySqlSnapshotContext snapshotContext, TableId tableId) throws Exception {
        LOG.debug("Snapshotting table {}", (Object)tableId);
        this.createDataEventsForTable(snapshotContext, this.snapshotReceiver, this.databaseSchema.tableFor(tableId));
        this.snapshotReceiver.completeSnapshot();
    }

    private void createDataEventsForTable(MySqlSnapshotContext snapshotContext, EventDispatcher.SnapshotReceiver<MySqlPartition> snapshotReceiver, Table table) throws InterruptedException {
        long exportStart = this.clock.currentTimeInMillis();
        LOG.info("Exporting data from split '{}' of table {}", (Object)this.snapshotSplit.splitId(), (Object)table.id());
        String selectSql = StatementUtils.buildSplitScanQuery(this.snapshotSplit.getTableId(), this.snapshotSplit.getSplitKeyType(), this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null);
        LOG.info("For split '{}' of table {} using select statement: '{}'", new Object[]{this.snapshotSplit.splitId(), table.id(), selectSql});
        try (PreparedStatement selectStatement = StatementUtils.readTableSplitDataStatement(this.jdbcConnection, selectSql, this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null, this.snapshotSplit.getSplitStart(), this.snapshotSplit.getSplitEnd(), this.snapshotSplit.getSplitKeyType().getFieldCount(), this.connectorConfig.getQueryFetchSize());
             ResultSet rs = selectStatement.executeQuery();){
            ColumnUtils.ColumnArray columnArray = ColumnUtils.toArray(rs, table);
            long rows = 0L;
            Threads.Timer logTimer = this.getTableScanLogTimer();
            while (rs.next()) {
                ++rows;
                Object[] row = new Object[columnArray.getGreatestColumnPosition()];
                for (int i = 0; i < columnArray.getColumns().length; ++i) {
                    Column actualColumn = table.columns().get(i);
                    row[columnArray.getColumns()[i].position() - 1] = this.readField(rs, i + 1, actualColumn, table);
                }
                if (logTimer.expired()) {
                    long stop = this.clock.currentTimeInMillis();
                    LOG.info("Exported {} records for split '{}' after {}", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration(stop - exportStart)});
                    this.snapshotChangeEventSourceMetrics.rowsScanned((MySqlPartition)snapshotContext.partition, table.id(), rows);
                    logTimer = this.getTableScanLogTimer();
                }
                this.dispatcher.dispatchSnapshotEvent((MySqlPartition)snapshotContext.partition, table.id(), this.getChangeRecordEmitter(snapshotContext, table.id(), row), snapshotReceiver);
            }
            LOG.info("Finished exporting {} records for split '{}', total duration '{}'", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration(this.clock.currentTimeInMillis() - exportStart)});
        }
        catch (SQLException e) {
            throw new ConnectException("Snapshotting of table " + table.id() + " failed", e);
        }
    }

    protected ChangeRecordEmitter<MySqlPartition> getChangeRecordEmitter(MySqlSnapshotContext snapshotContext, TableId tableId, Object[] row) {
        ((MySqlOffsetContext)snapshotContext.offset).event(tableId, this.clock.currentTime());
        return new SnapshotChangeRecordEmitter<Partition>(snapshotContext.partition, snapshotContext.offset, row, this.clock);
    }

    private Threads.Timer getTableScanLogTimer() {
        return Threads.timer(this.clock, LOG_INTERVAL);
    }

    private Object readField(ResultSet rs, int fieldNo, Column actualColumn, Table actualTable) throws SQLException {
        if (actualColumn.jdbcType() == 92) {
            return this.readTimeField(rs, fieldNo);
        }
        if (actualColumn.jdbcType() == 91) {
            return this.readDateField(rs, fieldNo, actualColumn, actualTable);
        }
        if (actualColumn.jdbcType() == 93) {
            return this.readTimestampField(rs, fieldNo, actualColumn, actualTable);
        }
        if (actualColumn.jdbcType() == -6 || actualColumn.jdbcType() == 5) {
            return rs.getObject(fieldNo) == null ? null : Integer.valueOf(rs.getInt(fieldNo));
        }
        return rs.getObject(fieldNo);
    }

    private Object readTimeField(ResultSet rs, int fieldNo) throws SQLException {
        Blob b = rs.getBlob(fieldNo);
        if (b == null) {
            return null;
        }
        try {
            return MySqlValueConverters.stringToDuration(new String(b.getBytes(1L, (int)b.length()), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Could not read MySQL TIME value as UTF-8");
            throw new RuntimeException(e);
        }
    }

    private Object readDateField(ResultSet rs, int fieldNo, Column column, Table table) throws SQLException {
        Blob b = rs.getBlob(fieldNo);
        if (b == null) {
            return null;
        }
        try {
            return MySqlValueConverters.stringToLocalDate(new String(b.getBytes(1L, (int)b.length()), "UTF-8"), column, table);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Could not read MySQL TIME value as UTF-8");
            throw new RuntimeException(e);
        }
    }

    private Object readTimestampField(ResultSet rs, int fieldNo, Column column, Table table) throws SQLException {
        Blob b = rs.getBlob(fieldNo);
        if (b == null) {
            return null;
        }
        try {
            return MySqlValueConverters.containsZeroValuesInDatePart(new String(b.getBytes(1L, (int)b.length()), "UTF-8"), column, table) ? null : rs.getTimestamp(fieldNo, Calendar.getInstance());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Could not read MySQL TIME value as UTF-8");
            throw new RuntimeException(e);
        }
    }

    private static class MySqlSnapshotContext
    extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext<MySqlPartition, MySqlOffsetContext> {
        public MySqlSnapshotContext(MySqlPartition partition) throws SQLException {
            super(partition, "");
        }
    }
}

