
package com.aliyun.sca.listener;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.TypeReference;
import com.aliyun.sca.domain.response.WebSocketResponse;
import com.aliyun.sca.enums.ApiTypeEnum;

/**
 * @author huyanan
 * @date 2025/1/6
 */
public abstract class WebSocketListener {

    /**
     * 开启识别的响应结果
     * @param response 开启识别的响应结果
     */
    public abstract void transStart(WebSocketResponse<Object> response);

    /**
     * 质检结果
     * @param response 质检结果
     */
    public abstract void qualityCheckResut(WebSocketResponse<Object> response);

    /**
     * 关闭识别的响应结果
     * @param response 关闭识别的响应结果
     */
    public abstract void transClose(WebSocketResponse<Object> response);

    /**
     * 质检完成
     * @param response 质检完成
     */
    public abstract void qualityComplete(WebSocketResponse<Object> response);

    /**
     * 更新质检状态的响应结果
     * @param response 更新质检状态的响应结果
     */
    public abstract void updateQualityResult(WebSocketResponse<Object> response);

    /**
     * 失败
     * @param response 失败
     */
    public abstract void onFail(WebSocketResponse<Object> response);

    public void onMessage(String message) {
        WebSocketResponse<Object> response = JSON.parseObject(message, new TypeReference<WebSocketResponse<Object>>() {});
        if (null == response || !response.isSuccess()) {
            onFail(response);
            return;
        }

        if (response.getApiType().equals(ApiTypeEnum.START_TRANS.name())) {
            transStart(response);

        } else if (response.getApiType().equals(ApiTypeEnum.CLOSE_TRANS.name())) {
            transClose(response);
        } else if (response.getApiType().equals(ApiTypeEnum.QUALITY_CHECK.name())) {
            qualityCheckResut(response);

        } else if (response.getApiType().equals(ApiTypeEnum.COMPLETE_TRANS.name())) {
            qualityComplete(response);

        } else if (response.getApiType().equals(ApiTypeEnum.UPDATE_QUALITY_STATE.name())) {
            updateQualityResult(response);
        }
    }
}
