package com.aliyun.sca.domain.request;

import com.aliyun.sca.enums.ApiTypeEnum;
import com.aliyun.sca.enums.RoleEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

/**
 * WebSocket消息体
 */
@Data
public class WebSocketMessage implements Serializable {
    private static final long serialVersionUID = -1L;

    private String apiType;

    private String type;

    private String voiceFileUrl;

    private int index;

    /**
     * 用户/客服信息
     */
    private String channelIdentity;

    private String channelRole;

    private Integer channelRoleId;

    private String channelRoleName;

    /**
     * 发送语音流
     */
    private byte[] data;

    /**
     * 开启asr识别需要
     */
    private Integer sampleRate;

    /**
     * 渠道
     */
    @Deprecated
    private List<ChannelInfo> channelList;

    /**
     * 通话信息
     */
    @Deprecated
    private ConversationInfo conversationInfo;

    public static WebSocketMessage packAsrStart(ApiTypeEnum typeEnum, RoleEnum roleEnum, Integer sampleRate) {
        WebSocketMessage channelMessage = new WebSocketMessage();
        channelMessage.setApiType(typeEnum.name());
        channelMessage.setChannelRole(roleEnum.getName());
        channelMessage.setSampleRate(sampleRate);
        return channelMessage;
    }

    public static WebSocketMessage packAudioData(ApiTypeEnum typeEnum, RoleEnum roleEnum, Integer roleId, String roleName, String roleIdentity) {
        WebSocketMessage audioMessage = new WebSocketMessage();
        audioMessage.setApiType(typeEnum.name());
        audioMessage.setChannelRole(roleEnum.getName());
        audioMessage.setChannelRoleId(roleId);
        audioMessage.setChannelRoleName(roleName);
        audioMessage.setChannelIdentity(roleIdentity);

        return audioMessage;
    }

    public static WebSocketMessage packageAsrClose(ApiTypeEnum typeEnum, RoleEnum roleEnum) {
        WebSocketMessage channelMessage = new WebSocketMessage();
        channelMessage.setApiType(typeEnum.name());
        channelMessage.setChannelRole(roleEnum.getName());
        return channelMessage;
    }

    public static WebSocketMessage packUpdateQuality(ApiTypeEnum typeEnum, String voiceUrl) {
        WebSocketMessage channelMessage = new WebSocketMessage();
        channelMessage.setApiType(typeEnum.name());
        channelMessage.setVoiceFileUrl(voiceUrl);
        return channelMessage;
    }
}
