package com.aliyun.wuying.demo.service.impl;



import com.aliyun.appstream_center20210218.Client;

import com.aliyun.tea.TeaException;
import com.aliyun.wuying.demo.param.GetAuthCodeParam;
import com.aliyun.wuying.demo.service.SampleService;
import com.google.gson.Gson;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Service;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;


import java.time.LocalDateTime;
import java.util.Objects;

import com.aliyun.appstream_center20210218.models.GetAuthCodeResponse;

@Service
public class SampleServiceImpl implements SampleService {

    private static final Logger log = LogManager.getLogger(SampleServiceImpl.class);

    static final Integer SUCCESS_CODE_INTEGER = 200;

    private static final Gson gson = new Gson();
    @Resource
    private Client appStreamCenterSdkClient;

    @Override
    public String hello() {
        LocalDateTime now = LocalDateTime.now();
        String time = now.toString();
        String result = "hello world, now is " + time;
        return result;
    }

    @Override
    public String getAuthCode(GetAuthCodeParam param) {

        log.info("try to getAuthCode, request: {}", gson.toJson(param));

        com.aliyun.appstream_center20210218.models.GetAuthCodeRequest getAuthCodeRequest = new com.aliyun.appstream_center20210218.models.GetAuthCodeRequest();
        getAuthCodeRequest.setEndUserId(param.getUserId());

        try {
            log.info("try to getAuthCode, request: {}", gson.toJson(getAuthCodeRequest));
            GetAuthCodeResponse response = appStreamCenterSdkClient.getAuthCode(getAuthCodeRequest);
            log.info("try to getAuthCode, request: {}",  gson.toJson(response));
            if (Objects.isNull(response) || Objects.isNull(response.getStatusCode())) {
                log.error("fail to getAuthCode: null response. request={}",  gson.toJson(getAuthCodeRequest));
                throw new RuntimeException("Internal Error");
            }

            if (! SUCCESS_CODE_INTEGER.equals(response.getStatusCode())) {
                log.error("fail to getAuthCode: bad statusCode. request={} code={}",
                    gson.toJson(getAuthCodeRequest), response.getStatusCode());
                throw new RuntimeException("Internal Error");
            }

            if (Objects.isNull(response.getBody())) {
                log.error("fail to getAuthCode: no body. request={} code={}",
                    gson.toJson(getAuthCodeRequest), response.getStatusCode());
                throw new RuntimeException("Internal Error");
            }

            if (Objects.isNull(response.getBody().getAuthModel())) {
                log.error("fail to getAuthCode: no authModel. request={} code={}",
                    gson.toJson(getAuthCodeRequest), response.getStatusCode());
                throw new RuntimeException("Internal Error");
            }

            return response.getBody().getAuthModel().getAuthCode();

        } catch (TeaException e) {
            log.error("fail to getAuthCode: code: {}, message: {}.", e.getCode(), e.getMessage());
            throw new RuntimeException(e.getMessage());
        } catch (Exception e) {
            log.error("fail to getAuthCode: message: {}.",  e.getMessage());
            throw new RuntimeException("Internal Error");
        }

    }

}
