package com.aliyun.wuying.demo.controller.impl;

import com.aliyun.wuying.demo.controller.SampleController;
import com.aliyun.wuying.demo.param.GetAuthCodeParam;
import com.aliyun.wuying.demo.service.SampleService;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(path = "/")
public class SampleControllerImpl implements SampleController {

    @Resource
    private SampleService sampleService;
    @Override
    @ResponseBody
    @RequestMapping(path = "/hello", method = {RequestMethod.GET, RequestMethod.POST})
    public String hello() {
        return sampleService.hello();
    }

    @Override
    @ResponseBody
    @RequestMapping(path = "/auth", method = {RequestMethod.GET, RequestMethod.POST})
    public String getAuthCode(@RequestBody(required = false) GetAuthCodeParam param) {
        return sampleService.getAuthCode(param);
    }


}
