package com.aliyun.wuying.demo.client;


import com.aliyun.appstream_center20210218.Client;
import com.aliyun.teaopenapi.models.Config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppstreamCenterSdkClientBean {
    /**
     * Http request long connection timeout
     */
    public static final Integer CONNECTION_TIMEOUT_MS = 10000;
    /**
     * http request default read timeout
     */
    public static final Integer READ_TIMEOUT_MS = 30000;

    @Value("${service.sdk.accessKeyId}")
    String serviceAccessKeyId;
    @Value("${service.sdk.accessSecret}")
    String serviceAccessSecret;
    @Value("${sdk.appstream.center.endpoint}")
    String appStreamCenterInnerEndpoint;
    @Value("${service.deploy.region}")
    String regionId;

    @Bean
    public Client appStreamCenterInnerSdkClient() {
        return getAppstreamCenterInnerSdkClient(regionId, appStreamCenterInnerEndpoint);
    }

    private Client getAppstreamCenterInnerSdkClient(String regionId, String endpoint) {
        Config config = new Config();
        config.setAccessKeyId(serviceAccessKeyId);
        config.setAccessKeySecret(serviceAccessSecret);
        config.setRegionId(regionId);
        config.setEndpoint(endpoint);
        config.setConnectTimeout(CONNECTION_TIMEOUT_MS);
        config.setReadTimeout(READ_TIMEOUT_MS);
        Client client;
        try {
            client = new Client(config);
        } catch (Exception e) {
            String errorMessage = "Init appstreamCenterInnerSdkClient Error.";
            throw new RuntimeException(errorMessage, e);
        }
        return client;
    }

}
