package org.example;

import com.alibaba.quickbi.pluginx.facade.error.BasicError;
import com.alibaba.quickbi.pluginx.facade.error.BasicException;
import com.alibaba.quickbi.pluginx.facade.error.BasicThrowException;

import java.util.Locale;

/**
 * @author yubai
 * @date 2024-09-13 17:45
 **/
public enum PluginLoginError implements BasicError {
    LOGIN_ACCOUNT_PASSWORD_ERROR("PLUGIN_002001", "账号或密码错误"),
    LOGIN_ACCOUNT_NOT_EXIST("PLUGIN_002002", "账号不存在"),
    LOGIN_CIPHER_ERROR("PLUGIN_002003", "验证码错误");

    private final String code;
    private final String message;

    private PluginLoginError(final String code, final String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public String getMessage(Locale locale) {
        return "";
    }

    @Override
    public Class<? extends BasicException> getExceptionClass() {
        return null;
    }

    @Override
    public Class<? extends BasicThrowException> getThrowExceptionClass() {
        return null;
    }
}
