package org.example;

import com.alibaba.quickbi.pluginx.facade.error.PluginCustomException;
import com.alibaba.quickbi.pluginx.facade.login.AbstractLoginCustomHandler;
import com.alibaba.quickbi.pluginx.facade.login.error.PluginLoginRedirectException;
import com.alibaba.quickbi.pluginx.facade.login.model.PluginUserAccount;
import com.alibaba.quickbi.pluginx.facade.model.CustomContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

/**
 * 说明！！！
 * DemoLoginCustomHandler仅需实现以下三个方法
 * 1. getAuthServerUrl
 * 2. login
 * 3. logout
 * 实现后，在QuickBI插件管理中配置该插件时，插件执行类名为：org.example.DemoLoginCustomHandler
 */
public class DemoLoginCustomHandler extends AbstractLoginCustomHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger("thirdPlugin");


    public String getAuthServerUrl(HttpServletRequest request) {
        // 授权服务的登录地址
        return "";
    }

    @Override
    public PluginUserAccount login(HttpServletRequest request, CustomContext customContext) throws PluginLoginRedirectException, PluginCustomException {
        // 以下为demo，按身份认证系统的实际情况实现
        final String accountName = Optional.ofNullable(request.getParameter("accountName")).orElse("13213535589");
        final String cipher = Optional.ofNullable(request.getParameter("cipher")).orElse("123456");
        final String captchaCode = Optional.ofNullable(request.getParameter("captchaCode")).orElse("1234");
        if (!captchaCode.equals("1234")) {
            throw new PluginCustomException(PluginLoginError.LOGIN_CIPHER_ERROR);
        }
        if (!accountName.equals("13213535589") || !cipher.equals("123456")) {
            throw new PluginCustomException(PluginLoginError.LOGIN_ACCOUNT_PASSWORD_ERROR);
        }
        LOGGER.info("[custom login] query user info with: account name = {}", accountName);
        final PluginUserAccount userAccount = new PluginUserAccount();
        userAccount.setAccoutId("user_u7dv2zogv4tm2jzqyrd2f44fi4");
        userAccount.setAccountName(accountName);
        userAccount.setNick("清云");
        return userAccount;
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response, CustomContext customContext) throws PluginLoginRedirectException {
        LOGGER.info("执行用户态登出操作");
    }
}
