/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.fpm.AssociationRules;
import org.apache.spark.mllib.fpm.FPGrowth;

public class JavaAssociationRulesExample {
    public static void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("JavaAssociationRulesExample");
        JavaSparkContext sc = new JavaSparkContext(sparkConf);
        JavaRDD freqItemsets = sc.parallelize(Arrays.asList(new FPGrowth.FreqItemset((Object)new String[]{"a"}, 15L), new FPGrowth.FreqItemset((Object)new String[]{"b"}, 35L), new FPGrowth.FreqItemset((Object)new String[]{"a", "b"}, 12L)));
        AssociationRules arules = new AssociationRules().setMinConfidence(0.8);
        JavaRDD results = arules.run(freqItemsets);
        for (AssociationRules.Rule rule : results.collect()) {
            System.out.println(String.valueOf(rule.javaAntecedent()) + " => " + String.valueOf(rule.javaConsequent()) + ", " + rule.confidence());
        }
        sc.stop();
    }
}

