/*
 * Copyright Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyun.lindorm.ldspark.examples

import org.apache.spark.SparkConf
import org.apache.spark.sql.SparkSession

/**
 * A simple word count example.
 */
object WordCountOfScala {

  def main(args:Array[String]): Unit ={

    val conf = new SparkConf()
    // !!!!
    // Enable below setting when running in local;
    // Remove below setting when running in cluster;
    // conf.setMaster("local[2]")

    val spark = SparkSession.builder()
      .config(conf)
      .appName("WordCount")
      .getOrCreate()

    // Construct a RDD from lines of text.
    val lines = spark.sparkContext.makeRDD(
      Seq(
        "Hello ~ I am from China ~ Where are you from ~",
        "Hello ~ I am from Russia ~",
      ), 2)

    // Split lines to get words and reduce to get the count.
    val wordCount = lines
      .flatMap(line => line.split(" ").map((_, 1)))
      .reduceByKey((a, b) => a + b)
      .collect()

    // Output the result.
    wordCount.foreach(println)
  }
}
