#
#  Copyright Alibaba Group Holding Ltd.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

import sys
import time

from your_project.main import main

if __name__ == "__main__":
    # The normal operation of SparkUI depends on SparkSession is running,
    # so if anything you want to retrieve from SparkUI, pass "InitAndCatchSparkSession"
    # as the first parameter when submitting your spark application please, this will
    # trigger the following code and init a simple SparkSession
    if len(sys.argv) >= 2 and sys.argv[1] == "InitAndCatchSparkSession":
        print("=========== InitAndCatchSparkSession \n")
        print(sys.argv[1])
        try:
            from pyspark.sql import SparkSession
            simple_spark_session = SparkSession \
                .builder \
                .appName("PythonSimpleCatchException") \
                .getOrCreate()
            print(simple_spark_session.conf)
            sys.argv.pop(1)
            main(sys.argv)
        except Exception as err:
            # Catch all exception and sleep 30 min here
            print("Catch exception: " + str(err))
            print("Sleep 30min ...")
            time.sleep(60 * 30)
        finally:
            simple_spark_session.stop()
    else:
        main(sys.argv)
