/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.concurrent;

import com.opencsv.bean.BeanVerifier;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.OpencsvUtils;
import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang3.ObjectUtils;

public class ProcessCsvLine<T>
implements Runnable {
    private final long lineNumber;
    private final MappingStrategy<T> mapper;
    private final CsvToBeanFilter filter;
    private final List<BeanVerifier<T>> verifiers;
    private final String[] line;
    private final BlockingQueue<OrderedObject<T>> resultantBeanQueue;
    private final BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue;
    private final boolean throwExceptions;

    public ProcessCsvLine(long lineNumber, MappingStrategy<T> mapper, CsvToBeanFilter filter, List<BeanVerifier<T>> verifiers, String[] line, BlockingQueue<OrderedObject<T>> resultantBeanQueue, BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue, boolean throwExceptions) {
        this.lineNumber = lineNumber;
        this.mapper = mapper;
        this.filter = filter;
        this.verifiers = ObjectUtils.defaultIfNull(verifiers, Collections.emptyList());
        this.line = line;
        this.resultantBeanQueue = resultantBeanQueue;
        this.thrownExceptionsQueue = thrownExceptionsQueue;
        this.throwExceptions = throwExceptions;
    }

    @Override
    public void run() {
        try {
            if (this.filter == null || this.filter.allowLine(this.line)) {
                T obj = this.processLine();
                ListIterator<BeanVerifier<T>> verifierList = this.verifiers.listIterator();
                boolean keep = true;
                while (keep && verifierList.hasNext()) {
                    keep = verifierList.next().verifyBean(obj);
                }
                if (keep) {
                    OpencsvUtils.queueRefuseToAcceptDefeat(this.resultantBeanQueue, new OrderedObject<T>(this.lineNumber, obj));
                }
            }
        }
        catch (CsvException e) {
            e.setLineNumber(this.lineNumber);
            e.setLine(this.line);
            if (this.throwExceptions) {
                throw new RuntimeException(e);
            }
            OpencsvUtils.queueRefuseToAcceptDefeat(this.thrownExceptionsQueue, new OrderedObject<CsvException>(this.lineNumber, e));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private T processLine() throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException, CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        return this.mapper.populateNewBean(this.line);
    }
}

