/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractCsvConverter;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ConverterNumber
extends AbstractCsvConverter {
    private final DecimalFormat df;

    public ConverterNumber(Class<?> type, String locale, Locale errorLocale, String formatString) throws CsvBadConverterException {
        super(type, locale, errorLocale);
        if (!Number.class.isAssignableFrom(this.type.isPrimitive() ? ClassUtils.primitiveToWrapper(this.type) : this.type)) {
            throw new CsvBadConverterException(ConverterNumber.class, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("csvnumber.not.number"));
        }
        NumberFormat nf = NumberFormat.getInstance(ObjectUtils.defaultIfNull(this.locale, Locale.getDefault(Locale.Category.FORMAT)));
        if (!(nf instanceof DecimalFormat)) {
            throw new CsvBadConverterException(ConverterNumber.class, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("numberformat.not.decimalformat"));
        }
        this.df = (DecimalFormat)nf;
        try {
            this.df.applyLocalizedPattern(formatString);
        }
        catch (IllegalArgumentException e) {
            CsvBadConverterException csve = new CsvBadConverterException(ConverterNumber.class, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("invalid.number.pattern"), formatString));
            csve.initCause(e);
            throw csve;
        }
        if (this.type == BigInteger.class || this.type == BigDecimal.class) {
            this.df.setParseBigDecimal(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convertToRead(String value) throws CsvDataTypeMismatchException {
        Number n;
        try {
            DecimalFormat decimalFormat = this.df;
            synchronized (decimalFormat) {
                n = this.df.parse(value);
            }
        }
        catch (ParseException e) {
            CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, this.type, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("unparsable.number"), value, this.df.toPattern()));
            csve.initCause(e);
            throw csve;
        }
        if (this.type == Byte.class || this.type == Byte.TYPE) {
            n = n.byteValue();
        } else if (this.type == Short.class || this.type == Short.TYPE) {
            n = n.shortValue();
        } else if (this.type == Integer.class || this.type == Integer.TYPE) {
            n = n.intValue();
        } else if (this.type == Long.class || this.type == Long.TYPE) {
            n = n.longValue();
        } else if (this.type == Float.class || this.type == Float.TYPE) {
            n = Float.valueOf(n.floatValue());
        } else if (this.type == Double.class || this.type == Double.TYPE) {
            n = n.doubleValue();
        } else if (this.type == BigInteger.class) {
            n = ((BigDecimal)n).toBigInteger();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String convertToWrite(Object value) {
        DecimalFormat decimalFormat = this.df;
        synchronized (decimalFormat) {
            return value != null ? this.df.format(value) : null;
        }
    }
}

