/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.analyticdb.adb4pgclient.hash;

import com.alibaba.cloud.analyticdb.adb4pgclient.Adb4pgClientException;
import com.alibaba.cloud.analyticdb.adb4pgclient.hash.GreenplumHashFunc;
import com.alibaba.cloud.analyticdb.adb4pgclient.hash.util.UInt32;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreenplumCdbHash {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Logger LOG = LoggerFactory.getLogger(GreenplumCdbHash.class);

    public static int getTargetSegmentId(String[] values, int[] isNulls, int[] dataType, int nKeys, int numSegments) {
        int hash = 0;
        int targetSeg = 0;
        if (nKeys <= 0) {
            return targetSeg;
        }
        for (int i = 0; i < nKeys; ++i) {
            hash = GreenplumCdbHash.cdbHash((UInt32)new UInt32((int)hash), (String)values[i], (int)isNulls[i], (int)dataType[i]).uintVal;
        }
        targetSeg = (int)GreenplumCdbHash.cdbHashReduce(new UInt32(hash), numSegments);
        return targetSeg;
    }

    public static long jumpConsistentHash(long key, int numSegments) {
        long b = -1L;
        long j = 0L;
        while (j < (long)numSegments) {
            b = j;
            key = key * 2862933555777941757L + 1L;
            j = (long)((double)(b + 1L) * (2.147483648E9 / (double)((key >>> 33) + 1L)));
        }
        return b;
    }

    public static UInt32 cdbHash(UInt32 hash, String value, int isNull, int type) {
        UInt32 hashKey = new UInt32(hash.uintVal);
        UInt32 orLeft = hashKey.shiftLeft(1);
        UInt32 right = hashKey.and(new UInt32(Integer.MIN_VALUE));
        if (right.longValue() > 0L) {
            right = new UInt32(1);
        }
        hashKey = orLeft.or(right);
        if (isNull == 0) {
            UInt32 hKey = new UInt32(0);
            switch (type) {
                case 16: {
                    if (value.length() != 1) {
                        throw new Adb4pgClientException(999, "boolean type is invalid", new Throwable(""));
                    }
                    hKey = GreenplumHashFunc.hashBoolean(value.charAt(0));
                    break;
                }
                case 5: {
                    hKey = GreenplumHashFunc.hashInt2(Integer.parseInt(value));
                    break;
                }
                case 4: {
                    hKey = GreenplumHashFunc.hashInt4(Integer.parseInt(value));
                    break;
                }
                case -5: {
                    hKey = GreenplumHashFunc.hashInt8(Long.parseLong(value));
                    break;
                }
                case 6: 
                case 7: {
                    hKey = GreenplumHashFunc.hashFloat4(Float.parseFloat(value));
                    break;
                }
                case 8: {
                    hKey = GreenplumHashFunc.hashFloat8(Double.parseDouble(value));
                    break;
                }
                case 2: 
                case 3: {
                    hKey = GreenplumHashFunc.hashNumeric(value);
                    break;
                }
                case 1: 
                case 12: {
                    hKey = GreenplumHashFunc.hashBpChar(value, DEFAULT_CHARSET);
                    break;
                }
                case 93: {
                    hKey = GreenplumHashFunc.timestampHash(value, true);
                    break;
                }
                case 92: {
                    if (value.contains("+") || value.contains("-")) {
                        hKey = GreenplumHashFunc.timetzHash(value, true);
                        break;
                    }
                    hKey = GreenplumHashFunc.timeHash(value, true);
                    break;
                }
                case 2014: {
                    hKey = GreenplumHashFunc.timestamptzHash(value, true, "+00:00");
                    break;
                }
                case 91: {
                    hKey = GreenplumHashFunc.dateHash(value);
                    break;
                }
                default: {
                    throw new Adb4pgClientException(999, "meet invalid data type in distribute key, value sql type is " + type, new Throwable());
                }
            }
            hashKey = hashKey.xor(hKey);
        }
        return hashKey;
    }

    public static long cdbHashReduce(UInt32 hash, int numSegments) {
        long result = 0L;
        result = GreenplumCdbHash.jumpConsistentHash(hash.longValue(), numSegments);
        return result;
    }

    public static UInt32 hashUInt32(UInt32 k) {
        return GreenplumCdbHash.hashBytesUint32(k);
    }

    public static UInt32 hashAny(byte[] k, int keyLen) {
        UInt32 a = new UInt32(-1640531527).add(new UInt32(keyLen)).add(new UInt32(3923095));
        UInt32 b = new UInt32(-1640531527).add(new UInt32(keyLen)).add(new UInt32(3923095));
        UInt32 c = new UInt32(-1640531527).add(new UInt32(keyLen)).add(new UInt32(3923095));
        int i = 0;
        while (keyLen >= 12) {
            a = a.add(k[i]);
            a = a.add(new UInt32(k[i + 1]).shiftLeft(8));
            a = a.add(new UInt32(k[i + 2]).shiftLeft(16));
            a = a.add(new UInt32(k[i + 3]).shiftLeft(24));
            b = b.add(k[i + 4]).add(new UInt32(k[i + 5]).shiftLeft(8)).add(new UInt32(k[i + 6]).shiftLeft(16)).add(new UInt32(k[i + 7]).shiftLeft(24));
            c = c.add(k[i + 8]).add(new UInt32(k[i + 9]).shiftLeft(8)).add(new UInt32(k[i + 10]).shiftLeft(16)).add(new UInt32(k[i + 11]).shiftLeft(24));
            UInt32[] mixArray = new UInt32[]{a, b, c};
            GreenplumCdbHash.mix(mixArray);
            a = mixArray[0];
            b = mixArray[1];
            c = mixArray[2];
            keyLen -= 12;
            i += 12;
        }
        int j = keyLen + i - 1;
        switch (keyLen) {
            case 11: {
                c = c.add(new UInt32(k[j]).shiftLeft(24));
                --j;
            }
            case 10: {
                c = c.add(new UInt32(k[j]).shiftLeft(16));
                --j;
            }
            case 9: {
                c = c.add(new UInt32(k[j]).shiftLeft(8));
                --j;
            }
            case 8: {
                b = b.add(new UInt32(k[j]).shiftLeft(24));
                --j;
            }
            case 7: {
                b = b.add(new UInt32(k[j]).shiftLeft(16));
                --j;
            }
            case 6: {
                b = b.add(new UInt32(k[j]).shiftLeft(8));
                --j;
            }
            case 5: {
                b = b.add(new UInt32(k[j]));
                --j;
            }
            case 4: {
                a = a.add(new UInt32(k[j]).shiftLeft(24));
                --j;
            }
            case 3: {
                a = a.add(new UInt32(k[j]).shiftLeft(16));
                --j;
            }
            case 2: {
                a = a.add(new UInt32(k[j]).shiftLeft(8));
                --j;
            }
            case 1: {
                a = a.add(new UInt32(k[j]));
            }
        }
        UInt32[] finalArray = new UInt32[]{a, b, c};
        GreenplumCdbHash.finalFunc(finalArray);
        return finalArray[2];
    }

    public static UInt32 hashAny(char[] k, int keyLen) {
        UInt32 a = new UInt32(-1640531527).add(new UInt32(keyLen)).add(new UInt32(3923095));
        UInt32 b = new UInt32(-1640531527).add(new UInt32(keyLen)).add(new UInt32(3923095));
        UInt32 c = new UInt32(-1640531527).add(new UInt32(keyLen)).add(new UInt32(3923095));
        int i = 0;
        while (keyLen >= 12) {
            a = a.add(k[i]).add(new UInt32(k[i + 1]).shiftLeft(8)).add(new UInt32(k[i + 2]).shiftLeft(16)).add(new UInt32(k[i + 3]).shiftLeft(24));
            b = b.add(k[i + 4]).add(new UInt32(k[i + 5]).shiftLeft(8)).add(new UInt32(k[i + 6]).shiftLeft(16)).add(new UInt32(k[i + 7]).shiftLeft(24));
            c = c.add(k[i + 8]).add(new UInt32(k[i + 9]).shiftLeft(8)).add(new UInt32(k[i + 10]).shiftLeft(16)).add(new UInt32(k[i + 11]).shiftLeft(24));
            UInt32[] mixArray = new UInt32[]{a, b, c};
            GreenplumCdbHash.mix(mixArray);
            a = mixArray[0];
            b = mixArray[1];
            c = mixArray[2];
            keyLen -= 12;
            i += 12;
        }
        int j = keyLen + i - 1;
        switch (keyLen) {
            case 11: {
                c = c.add(new UInt32(k[j]).shiftLeft(24));
                --j;
            }
            case 10: {
                c = c.add(new UInt32(k[j]).shiftLeft(16));
                --j;
            }
            case 9: {
                c = c.add(new UInt32(k[j]).shiftLeft(8));
                --j;
            }
            case 8: {
                b = b.add(new UInt32(k[j]).shiftLeft(24));
                --j;
            }
            case 7: {
                b = b.add(new UInt32(k[j]).shiftLeft(16));
                --j;
            }
            case 6: {
                b = b.add(new UInt32(k[j]).shiftLeft(8));
                --j;
            }
            case 5: {
                b = b.add(new UInt32(k[j]));
                --j;
            }
            case 4: {
                a = a.add(new UInt32(k[j]).shiftLeft(24));
                --j;
            }
            case 3: {
                a = a.add(new UInt32(k[j]).shiftLeft(16));
                --j;
            }
            case 2: {
                a = a.add(new UInt32(k[j]).shiftLeft(8));
                --j;
            }
            case 1: {
                a = a.add(new UInt32(k[j]));
            }
        }
        UInt32[] finalArray = new UInt32[]{a, b, c};
        GreenplumCdbHash.finalFunc(finalArray);
        return finalArray[2];
    }

    public static UInt32 hashBytesUint32(UInt32 k) {
        UInt32 a = new UInt32(-1640531527).add(new UInt32(4)).add(new UInt32(3923095));
        UInt32 b = new UInt32(-1640531527).add(new UInt32(4)).add(new UInt32(3923095));
        UInt32 c = new UInt32(-1640531527).add(new UInt32(4)).add(new UInt32(3923095));
        a = a.add(k);
        UInt32[] inputArray = new UInt32[]{a, b, c};
        GreenplumCdbHash.finalFunc(inputArray);
        c = inputArray[2];
        return c;
    }

    public static UInt32 rot(UInt32 x, int y) {
        UInt32 left = x.shiftLeft(y);
        UInt32 right = x.shiftRight(32 - y);
        return left.or(right);
    }

    public static void mix(UInt32[] inputArray) {
        UInt32 a = inputArray[0];
        UInt32 b = inputArray[1];
        UInt32 c = inputArray[2];
        a = a.subtract(c);
        UInt32 rotC4 = GreenplumCdbHash.rot(c, 4);
        a = a.xor(rotC4);
        c = b.add(c);
        b = b.subtract(a);
        UInt32 rotA6 = GreenplumCdbHash.rot(a, 6);
        b = b.xor(rotA6);
        a = a.add(c);
        c = c.subtract(b);
        UInt32 rotB8 = GreenplumCdbHash.rot(b, 8);
        c = c.xor(rotB8);
        b = b.add(a);
        a = a.subtract(c);
        UInt32 rotC16 = GreenplumCdbHash.rot(c, 16);
        a = a.xor(rotC16);
        c = c.add(b);
        b = b.subtract(a);
        UInt32 rotA19 = GreenplumCdbHash.rot(a, 19);
        b = b.xor(rotA19);
        a = a.add(c);
        c = c.subtract(b);
        UInt32 rotB4 = GreenplumCdbHash.rot(b, 4);
        c = c.xor(rotB4);
        b = b.add(a);
        inputArray[0] = a;
        inputArray[1] = b;
        inputArray[2] = c;
    }

    public static void finalFunc(UInt32[] inputArray) {
        UInt32 a = inputArray[0];
        UInt32 b = inputArray[1];
        UInt32 c = inputArray[2];
        c = c.xor(b);
        UInt32 rotB14 = GreenplumCdbHash.rot(b, 14);
        c = c.subtract(rotB14);
        a = a.xor(c);
        UInt32 rotC11 = GreenplumCdbHash.rot(c, 11);
        a = a.subtract(rotC11);
        b = b.xor(a);
        UInt32 rotA25 = GreenplumCdbHash.rot(a, 25);
        b = b.subtract(rotA25);
        c = c.xor(b);
        UInt32 rotB16 = GreenplumCdbHash.rot(b, 16);
        c = c.subtract(rotB16);
        a = a.xor(c);
        UInt32 rotC4 = GreenplumCdbHash.rot(c, 4);
        a = a.subtract(rotC4);
        b = b.xor(a);
        UInt32 rotA14 = GreenplumCdbHash.rot(a, 14);
        b = b.subtract(rotA14);
        c = c.xor(b);
        UInt32 rotB24 = GreenplumCdbHash.rot(b, 24);
        c = c.subtract(rotB24);
        inputArray[0] = a;
        inputArray[1] = b;
        inputArray[2] = c;
    }
}

