/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.analyticdb.adb4pgclient;

import com.alibaba.cloud.analyticdb.adb4pgclient.Adb4pgClientException;
import com.alibaba.cloud.analyticdb.adb4pgclient.Adb4pgClientThreadFactory;
import com.alibaba.cloud.analyticdb.adb4pgclient.ClientDataSource;
import com.alibaba.cloud.analyticdb.adb4pgclient.ColumnDataType;
import com.alibaba.cloud.analyticdb.adb4pgclient.ColumnInfo;
import com.alibaba.cloud.analyticdb.adb4pgclient.DatabaseConfig;
import com.alibaba.cloud.analyticdb.adb4pgclient.Row;
import com.alibaba.cloud.analyticdb.adb4pgclient.TableInfo;
import com.alibaba.cloud.analyticdb.adb4pgclient.hash.GreenplumCdbHash;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.postgresql.util.PGbytea;

public class Adb4pgClient {
    private DatabaseConfig databaseConfig;
    private DruidDataSource dataSource;
    private Map<String, TableInfo> tableInfo;
    private Map<String, Boolean> isAllColumn;
    private CopyManager copyManager;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final String TABLE_NAME_QUOTE_CHARACTER = "\"";
    private static final String COLUMN_QUOTE_CHARACTER = "\"";
    private static final String ALL_COLUMN_CHARACTER = "*";
    private static final String FIELD_DELIMITER = "|";
    private static final String DOT = ".";
    private static final String SET_AUTOSTATS_MODE_OFF = "set gp_autostats_mode=none";
    private static final String SET_OPTIMIZER_OFF_SQL = "set optimizer = off";
    private static final String INFO = "info";
    private static final String ERROR = "error";
    private static final String PRIMARY_CONFLICT_ERROR_MSG_4_3_VERSION = "duplicatekeyviolatesuniqueconstraint";
    private static final String PRIMARY_CONFLICT_ERROR_CODE_6_0_VERSION = "ERROR:(23505)";
    private static final String PRIMARY_CONFLICT_ERROR_MSG_6_0_VERSION = "duplicatekeyvalueviolatesuniqueconstraint";
    private static final String SET_SEQSCAN_OFF_SQL = "set enable_seqscan = off";
    private final ExecutorService executorService;
    private LinkedBlockingQueue<Task> executeTaskQueue = new LinkedBlockingQueue();
    private List<String> commitExceptionDataList = Collections.synchronizedList(new ArrayList());
    private Exception exception = null;
    private Map<String, Map<String, String>> schemaNameTableNameCache;
    private Map<String, Map<String, Pair<Integer, String>>> tableColumnsMetaData;
    private Map<String, Map<String, Pair<Integer, String>>> configColumnsMetaData;
    private Map<String, Map<String, Row>> dataBuffer;
    private Map<String, Map<Integer, Map<String, Row>>> preHashDataBuffer;
    private Map<String, Long> bufferTableSize;
    private long totalCommittedSize = 0L;
    private ClientDataSource clientDataSource;
    CSVParser csvParser;
    CSVParserBuilder builder = new CSVParserBuilder();
    private boolean copyOnConflict = false;

    public Adb4pgClient(DatabaseConfig databaseConfig) {
        this.databaseConfig = databaseConfig;
        this.clientDataSource = ClientDataSource.getInstance();
        this.schemaNameTableNameCache = new ConcurrentHashMap<String, Map<String, String>>(16);
        this.executorService = new ThreadPoolExecutor(databaseConfig.getParallelNumber(), databaseConfig.getParallelNumber(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new Adb4pgClientThreadFactory(String.format("%s", databaseConfig.getDatabase())));
        this.initDatasource();
        this.initInstance();
        this.builder.withSeparator(FIELD_DELIMITER.charAt(0)).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS);
        this.csvParser = this.builder.build();
    }

    public Adb4pgClient(DatabaseConfig databaseConfig, DruidDataSource dataSource) {
        this.dataSource = dataSource;
        this.databaseConfig = databaseConfig;
        this.clientDataSource = ClientDataSource.getInstance();
        this.schemaNameTableNameCache = new ConcurrentHashMap<String, Map<String, String>>(16);
        this.executorService = new ThreadPoolExecutor(databaseConfig.getParallelNumber(), databaseConfig.getParallelNumber(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new Adb4pgClientThreadFactory(String.format("%s", databaseConfig.getTable())));
        this.initDatasource();
        this.initInstance();
        this.builder.withSeparator(FIELD_DELIMITER.charAt(0)).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS);
        this.csvParser = this.builder.build();
    }

    public void addRow(Row row, String tableName, String schemaName) {
        String schemaNameTableName;
        boolean enablePreHash = this.databaseConfig.getEnablePreHash();
        if (schemaName == null) {
            schemaName = "public";
        }
        if (this.tableInfo.get(schemaNameTableName = this.schemaNameTableNameCache.get(schemaName).get(tableName)) == null) {
            throw new Adb4pgClientException(106, "The table " + schemaName + DOT + tableName + " do not exist", null);
        }
        if (enablePreHash) {
            this.preHashDataBuffer.putIfAbsent(schemaNameTableName, new HashMap());
            this.bufferTableSize.putIfAbsent(schemaNameTableName, 0L);
        } else {
            this.dataBuffer.putIfAbsent(schemaNameTableName, new HashMap());
            this.bufferTableSize.putIfAbsent(schemaNameTableName, 0L);
        }
        try {
            String pkValue = this.generatePKValueString(tableName, schemaName, row);
            if (enablePreHash) {
                List<ColumnInfo> shardKeys = this.tableInfo.get(schemaNameTableName).getShardKeys();
                int segmentNumber = this.tableInfo.get(schemaNameTableName).getSegmentNumOfTable();
                Map<String, Pair<Integer, String>> columnTypes = this.configColumnsMetaData.get(schemaNameTableName);
                String[] shardKeyValues = this.getShardKeyValues(schemaNameTableName, shardKeys, row, columnTypes);
                int[] isNull = this.getShardKeysIsNull(shardKeys, row);
                int[] dataType = this.getShardKeysType(shardKeys, columnTypes);
                int segmentId = GreenplumCdbHash.getTargetSegmentId(shardKeyValues, isNull, dataType, shardKeys.size(), segmentNumber);
                Map writeDataMap = this.preHashDataBuffer.get(schemaNameTableName).computeIfAbsent(segmentId, k -> new HashMap());
                writeDataMap.put(pkValue, row);
            } else {
                this.dataBuffer.get(schemaNameTableName).put(pkValue, row);
            }
            String copyValue = this.generateCopyString(tableName, schemaName, row);
            this.bufferTableSize.put(schemaNameTableName, this.bufferTableSize.get(schemaNameTableName) + (long)copyValue.getBytes(StandardCharsets.UTF_8).length);
            if (this.bufferTableSize.get(schemaNameTableName) > this.databaseConfig.getCommitSize()) {
                this.commit(schemaNameTableName);
            }
        }
        catch (Adb4pgClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Adb4pgClientException(103, String.format("Add row data (%s) error: %s", row.getColumnValues().toString(), e.getMessage()), (Throwable)e);
        }
    }

    public TableInfo getTableInfo(String tableName, String schemaName) {
        return this.tableInfo.get(schemaName + DOT + tableName);
    }

    private void getTableInfo(String userInputDatabase, List<String> userInputTables, Connection connection) {
        this.getTableInfo(userInputDatabase, userInputTables, connection, false);
    }

    private void getTableInfo(String userInputDatabase, List<String> userInputTables, Connection connection, boolean forceRefresh) {
        if (userInputTables == null) {
            throw new RuntimeException("tables is not exist");
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            DatabaseMetaData md = connection.getMetaData();
            HashMap<String, List> columnInfoListMap = new HashMap<String, List>(16);
            for (String schemaTable : userInputTables) {
                String[] schemaAndTable = schemaTable.split("\\.");
                String schemaName = schemaAndTable[0];
                String tableName = schemaAndTable[1];
                String schemaTableQuote = "\"" + schemaName + "\"" + DOT + "\"" + tableName + "\"";
                columnInfoListMap.computeIfAbsent(schemaTable, k1 -> new ArrayList());
                statement = connection.createStatement();
                String columnMetaSql = String.format("select * from %s where 1=2", schemaTableQuote);
                rs = statement.executeQuery(columnMetaSql);
                ResultSetMetaData resultSetMetaData = rs.getMetaData();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    ColumnInfo columnInfo = new ColumnInfo();
                    columnInfo.setName(resultSetMetaData.getColumnName(i));
                    columnInfo.setDataType(ColumnDataType.getTypeByName(resultSetMetaData.getColumnTypeName(i).toUpperCase()));
                    columnInfo.setOrdinal(i);
                    boolean nullable = resultSetMetaData.isNullable(i) == 1;
                    columnInfo.setNullable(nullable);
                    columnInfo.setDefaultValue(null);
                    ((List)columnInfoListMap.get(schemaTable)).add(columnInfo);
                }
                ResultSet ts = md.getTables(userInputDatabase, schemaName, tableName, null);
                while (ts.next()) {
                    String tn = ts.getString(3);
                    String sn = ts.getString(2);
                    TableInfo tableInfoTmp = new TableInfo();
                    tableInfoTmp.setColumns((List)columnInfoListMap.get(sn + DOT + tn));
                    tableInfoTmp.setTableCatalog(userInputDatabase);
                    tableInfoTmp.setTableSchema(sn);
                    tableInfoTmp.setTableName(sn + DOT + tn);
                    tableInfoTmp.setTableType(ts.getString(4));
                    ArrayList<ColumnInfo> primaryKeyColumns = new ArrayList<ColumnInfo>();
                    rs = md.getPrimaryKeys(userInputDatabase, sn, tn);
                    while (rs.next()) {
                        String columnName = rs.getString("COLUMN_NAME");
                        List<ColumnInfo> columnsInfo = tableInfoTmp.getColumns();
                        if (columnsInfo == null) {
                            throw new Adb4pgClientException(108, "GetPrimaryKeys error: " + columnName + " is not exists", null);
                        }
                        for (ColumnInfo columnInfo : columnsInfo) {
                            if (!columnInfo.getName().equals(columnName)) continue;
                            primaryKeyColumns.add(columnInfo);
                        }
                    }
                    tableInfoTmp.setPrimaryKeyColumns(primaryKeyColumns);
                    List<ColumnInfo> shardKeys = this.getShardKeys(connection, tableName, schemaName);
                    int segmentNumber = this.getTableSegmentNumber(connection, tableName, schemaName);
                    tableInfoTmp.setShardKeys(shardKeys);
                    tableInfoTmp.setSegmentNumOfTable(segmentNumber);
                    this.tableInfo.put(sn + DOT + tn, tableInfoTmp);
                }
            }
            this.closeDBResources(rs, statement, null);
        }
        catch (Exception e) {
            throw new Adb4pgClientException(106, "GetTableInfo exception: " + e.getMessage(), null);
        }
        finally {
            this.closeDBResources(rs, statement, connection);
        }
    }

    public List<ColumnInfo> getColumnsInfo(String tableName, String schemaName) {
        return this.tableInfo.get(schemaName + DOT + tableName).getColumns();
    }

    public boolean columnExistsByName(String schemaName, String tableName, String columnName) {
        for (ColumnInfo columnInfo : this.getColumnsInfo(tableName, schemaName)) {
            if (!columnInfo.getName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public int getIndexFromColumnName(String schemaName, String tableName, String columnName) {
        TableInfo tableInfo = this.tableInfo.get(schemaName + DOT + tableName);
        if (tableInfo == null) {
            return -1;
        }
        for (ColumnInfo columnInfo : tableInfo.getColumns()) {
            if (!columnInfo.getName().equals(columnName)) continue;
            return columnInfo.getOrdinal();
        }
        return -1;
    }

    public List<ColumnInfo> getPrimaryKeyColumns(String tableName, String schemaName) {
        return this.tableInfo.get(schemaName + DOT + tableName).getPrimaryKeyColumns();
    }

    public void addRows(List<Row> rows, String tableName, String schemaName) {
        for (Row row : rows) {
            this.addRow(row, tableName, schemaName);
        }
    }

    public void addMap(Map<String, String> oriMap, String tableName, String schemaName) {
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        for (Map.Entry<String, String> entry : oriMap.entrySet()) {
            dataMap.put(entry.getKey(), entry.getValue());
        }
        if (this.tableInfo.get(this.schemaNameTableNameCache.get(schemaName).get(tableName)) == null) {
            throw new Adb4pgClientException(106, "The table " + tableName + " do not exist", null);
        }
        Row row = this.mapToRow(dataMap, tableName, schemaName);
        this.addRow(row, tableName, schemaName);
    }

    public void addMaps(List<Map<String, String>> maps, String tableName, String schemaName) {
        for (Map<String, String> map : maps) {
            this.addMap(map, tableName, schemaName);
        }
    }

    private void commit(String schemaNameTableName) {
        String[] s2 = schemaNameTableName.split("\\.");
        if (this.databaseConfig.getEnablePreHash()) {
            Map<Integer, Map<String, Row>> tableBufferData = this.preHashDataBuffer.get(schemaNameTableName);
            for (Map<String, Row> segmentBuffer : tableBufferData.values()) {
                ArrayList<Row> dedupeRows = new ArrayList<Row>(segmentBuffer.values());
                Task task = new Task(dedupeRows, s2[1], s2[0], schemaNameTableName, this.databaseConfig.getColumns(s2[1], s2[0]));
                this.executeTaskQueue.add(task);
            }
            this.taskQueueExecute();
            this.preHashDataBuffer.get(schemaNameTableName).clear();
        } else {
            Map<String, Row> dedupeRowMap = this.dataBuffer.get(schemaNameTableName);
            ArrayList<Row> dedupeRows = new ArrayList<Row>(dedupeRowMap.values());
            Task task = new Task(dedupeRows, s2[1], s2[0], schemaNameTableName, this.databaseConfig.getColumns(s2[1], s2[0]));
            this.executeTaskQueue.add(task);
            this.taskQueueExecute();
            this.dataBuffer.get(schemaNameTableName).clear();
        }
        this.totalCommittedSize += this.bufferTableSize.get(schemaNameTableName).longValue();
        this.bufferTableSize.put(schemaNameTableName, 0L);
    }

    public void commit() {
        String tableName;
        String schemaName;
        String schemaNameTableName;
        if (this.databaseConfig.getEnablePreHash()) {
            for (Map.Entry<String, Map<Object, Object>> entry : this.preHashDataBuffer.entrySet()) {
                schemaNameTableName = entry.getKey();
                schemaName = schemaNameTableName.split("\\.")[0];
                tableName = schemaNameTableName.split("\\.")[1];
                Map<Integer, Map<String, Row>> tableBufferData = this.preHashDataBuffer.get(schemaNameTableName);
                for (Map<String, Row> segmentBuffer : tableBufferData.values()) {
                    ArrayList<Row> dedupeRows = new ArrayList<Row>(segmentBuffer.values());
                    Task task = new Task(dedupeRows, tableName, schemaName, schemaNameTableName, this.databaseConfig.getColumns(tableName, schemaName));
                    this.executeTaskQueue.add(task);
                }
            }
            this.taskQueueExecute();
            this.preHashDataBuffer.clear();
        } else {
            for (Map.Entry<String, Map<Object, Object>> entry : this.dataBuffer.entrySet()) {
                schemaNameTableName = entry.getKey();
                schemaName = schemaNameTableName.split("\\.")[0];
                tableName = schemaNameTableName.split("\\.")[1];
                Map<String, Row> dedupedLineMap = this.dataBuffer.get(schemaNameTableName);
                ArrayList<Row> tableCopyRows = new ArrayList<Row>(dedupedLineMap.values());
                Task task = new Task(tableCopyRows, tableName, schemaName, schemaNameTableName, this.databaseConfig.getColumns(tableName, schemaName));
                this.executeTaskQueue.add(task);
            }
            this.taskQueueExecute();
            this.dataBuffer.clear();
        }
        for (Map.Entry<String, Object> entry : this.bufferTableSize.entrySet()) {
            this.totalCommittedSize += ((Long)entry.getValue()).longValue();
        }
        this.bufferTableSize.clear();
    }

    public long getTotalCommittedSize() {
        return this.totalCommittedSize;
    }

    private void taskQueueExecute() {
        ArrayList futureList = new ArrayList();
        final CountDownLatch latch = new CountDownLatch(this.databaseConfig.getParallelNumber());
        for (int i = 0; i < this.databaseConfig.getParallelNumber(); ++i) {
            Future<?> future = this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Task task;
                        while ((task = (Task)Adb4pgClient.this.executeTaskQueue.poll()) != null) {
                            Adb4pgClient.this.copyBatchData(task);
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            futureList.add(future);
        }
        try {
            latch.await();
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (Exception e) {
            this.logger(ERROR, "commit " + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
        if (!this.commitExceptionDataList.isEmpty()) {
            throw new Adb4pgClientException(101, this.commitExceptionDataList, (Throwable)this.exception);
        }
    }

    protected String generateCopyString(String tableName, String schemaName, Row row) {
        StringBuilder rowsb = new StringBuilder();
        String schemaNameTableName = this.schemaNameTableNameCache.get(schemaName).get(tableName);
        try {
            rowsb.setLength(0);
            List<Object> columnValues = row.getColumnValues();
            int i = 0;
            List<String> tableColumns = this.databaseConfig.getColumns(tableName, schemaName);
            for (String columnName : tableColumns) {
                ColumnInfo column;
                int columnSqltype = this.configColumnsMetaData.get(schemaNameTableName).get(columnName).getLeft();
                String s2 = row.getColumnValues().size() <= i || row.getColumnValues().get(i) == null ? ((column = this.tableInfo.get(schemaNameTableName).getColumns().get(i)).getDefaultValue() != null ? this.dataConvertor(columnSqltype, column.getDefaultValue(), schemaNameTableName, columnName) : null) : this.dataConvertor(columnSqltype, columnValues.get(i), schemaNameTableName, columnName);
                if (s2 != null) {
                    rowsb.append("\"").append(s2).append("\"");
                }
                if (i < tableColumns.size() - 1) {
                    rowsb.append(FIELD_DELIMITER);
                }
                ++i;
            }
            rowsb.append(IOUtils.LINE_SEPARATOR);
        }
        catch (Exception e) {
            throw new Adb4pgClientException(103, e.getMessage(), (Throwable)e);
        }
        return rowsb.toString();
    }

    private String generatePKValueString(String tableName, String schemaName, Row row) {
        StringBuilder rowsb = new StringBuilder();
        String schemaNameTableName = this.schemaNameTableNameCache.get(schemaName).get(tableName);
        try {
            rowsb.setLength(0);
            List<ColumnInfo> primaryKeyColumns = this.getTableInfo(tableName, schemaName).getPrimaryKeyColumns();
            if (primaryKeyColumns == null || primaryKeyColumns.isEmpty()) {
                rowsb.append(UUID.randomUUID());
                return rowsb.toString();
            }
            List<Object> columnValues = row.getColumnValues();
            for (ColumnInfo col : primaryKeyColumns) {
                String pkColumnName = col.getName();
                int indexInTable = col.getOrdinal();
                String pkColumnValue = null;
                int columnSqltype = this.configColumnsMetaData.get(schemaNameTableName).get(pkColumnName).getLeft();
                if (columnValues.get(indexInTable - 1) == null) {
                    if (this.tableInfo.get(schemaNameTableName).getColumns().get(indexInTable - 1).getDefaultValue() != null) {
                        pkColumnValue = this.dataConvertor(columnSqltype, this.tableInfo.get(schemaNameTableName).getColumns().get(indexInTable - 1).getDefaultValue(), schemaNameTableName, pkColumnName);
                        rowsb.append(pkColumnValue);
                    } else {
                        rowsb.append(pkColumnValue);
                    }
                } else {
                    rowsb.append(this.dataConvertor(columnSqltype, columnValues.get(indexInTable - 1), schemaNameTableName, pkColumnName));
                }
                if (pkColumnValue != null) {
                    rowsb.append("\"").append(pkColumnValue).append("\"");
                }
                if (indexInTable == row.getColumnValues().size() - 1) continue;
                rowsb.append(FIELD_DELIMITER);
            }
        }
        catch (Exception e) {
            throw new Adb4pgClientException(103, e.getMessage(), (Throwable)e);
        }
        return rowsb.toString();
    }

    private String generateColumnString(List<String> tableColumns) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String col : tableColumns) {
            sb.append("\"").append(col).append("\"");
            if (++i >= tableColumns.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCopy(ByteArrayOutputStream outputStream, String schemaNameTableName, List<String> tableColumns, Connection conn) throws SQLException, Exception {
        String table = "\"" + this.databaseConfig.getDatabase() + "\"" + DOT + "\"" + this.tableInfo.get(schemaNameTableName).getTableSchema() + "\"" + DOT + "\"" + schemaNameTableName.split("\\.")[1] + "\"";
        String columnString = this.generateColumnString(tableColumns);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        try {
            BaseConnection baseConnection = (BaseConnection)conn.getMetaData().getConnection();
            this.copyManager = new CopyManager(baseConnection);
            if (this.copyOnConflict) {
                this.copyManager.copyIn("COPY " + table + " (" + columnString + ") FROM STDIN DELIMITER '" + FIELD_DELIMITER + "'  ESCAPE '\\' CSV QUOTE '" + "\"" + "' DO on conflict DO update ", inputStream);
            } else {
                this.copyManager.copyIn("COPY " + table + " (" + columnString + ") FROM STDIN DELIMITER '" + FIELD_DELIMITER + "'  ESCAPE '\\' CSV QUOTE '" + "\"" + "'", inputStream);
            }
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    private ByteArrayOutputStream getByteStream(String tableName, String schemaName, List<Row> rows) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (Row row : rows) {
            String copyString = this.generateCopyString(tableName, schemaName, row);
            byteArrayOutputStream.write(copyString.getBytes(StandardCharsets.UTF_8));
        }
        return byteArrayOutputStream;
    }

    private void copyBatchData(Task task) {
        this.copyBatchData(task.outputRows, task.tableName, task.schemaName, task.schemaNameTableName, task.tableColumns);
    }

    private void copyBatchData(List<Row> outputRows, String tableName, String schemaName, String schemaNameTableName, List<String> tableColumns) {
        ByteArrayOutputStream w = null;
        Connection connection = this.getConnectionWithSetting();
        try {
            w = this.getByteStream(tableName, schemaName, outputRows);
            this.executeCopy(w, schemaNameTableName, tableColumns, connection);
            w.close();
        }
        catch (SQLException e) {
            this.logger(ERROR, e.getMessage());
            this.copyEachRow(tableName, schemaName, schemaNameTableName, tableColumns);
        }
        catch (Adb4pgClientException e1) {
            throw e1;
        }
        catch (Exception e2) {
            this.logger(ERROR, "commit " + e2.getMessage());
            throw new RuntimeException(e2.getMessage(), e2);
        }
        finally {
            this.closeDBResources(null, null, connection);
        }
    }

    private void copyEachRow(String tableName, String schemaName, String schemaNameTableName, List<String> userInputTableColumns) {
        if (this.databaseConfig.isInsertIgnore()) {
            this.copyEachRowIgnore(tableName, schemaName, schemaNameTableName, userInputTableColumns);
        } else {
            this.copyEachRowOverride(tableName, schemaName, schemaNameTableName, userInputTableColumns);
        }
    }

    private void copyEachRowIgnore(String tableName, String schemaName, String schemaNameTableName, List<String> userInputTableColumns) {
        Map<Object, Object> dedupeRowMap = new HashMap();
        if (this.databaseConfig.getEnablePreHash()) {
            Map<Integer, Map<String, Row>> preHashDataBuffer = this.preHashDataBuffer.get(schemaNameTableName);
            for (Integer segmentId : preHashDataBuffer.keySet()) {
                Map<String, Row> singleSegmentId = preHashDataBuffer.get(segmentId);
                for (String key : singleSegmentId.keySet()) {
                    dedupeRowMap.put(key, singleSegmentId.get(key));
                }
            }
        } else {
            dedupeRowMap = this.dataBuffer.get(schemaNameTableName);
        }
        ArrayList<Object> copyRows = new ArrayList<Object>(dedupeRowMap.values());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Connection connection = null;
        for (Row row : copyRows) {
            String copyString = this.generateCopyString(tableName, schemaName, row);
            byte[] rawData = copyString.getBytes(StandardCharsets.UTF_8);
            try {
                connection = this.getConnectionWithSetting();
                byteArrayOutputStream.write(rawData);
                this.executeCopy(byteArrayOutputStream, schemaNameTableName, userInputTableColumns, connection);
            }
            catch (SQLException e) {
                String errorMessage = e.getMessage();
                if (errorMessage != null) {
                    errorMessage = errorMessage.replaceAll("\\s", "");
                }
                assert (errorMessage != null);
                if (errorMessage.contains(PRIMARY_CONFLICT_ERROR_MSG_4_3_VERSION) || errorMessage.contains(PRIMARY_CONFLICT_ERROR_CODE_6_0_VERSION) || errorMessage.contains(PRIMARY_CONFLICT_ERROR_MSG_6_0_VERSION)) continue;
                this.commitExceptionDataList.add(copyString);
                this.exception = e;
            }
            catch (Exception e) {
                throw new Adb4pgClientException(102, e.getMessage() + e.getCause().toString(), (Throwable)e);
            }
            finally {
                byteArrayOutputStream.reset();
                this.closeDBResources(null, null, connection);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyEachRowOverride(String tableName, String schemaName, String schemaNameTableName, List<String> userInputTableColumns) {
        Map<Object, Object> dedupeRowMap = new HashMap();
        if (this.databaseConfig.getEnablePreHash()) {
            Map<Integer, Map<String, Row>> preHashDataBuffer = this.preHashDataBuffer.get(schemaNameTableName);
            for (Integer segmentId : preHashDataBuffer.keySet()) {
                Map<String, Row> singleSegmentId = preHashDataBuffer.get(segmentId);
                for (String key : singleSegmentId.keySet()) {
                    dedupeRowMap.put(key, singleSegmentId.get(key));
                }
            }
        } else {
            dedupeRowMap = this.dataBuffer.get(schemaNameTableName);
        }
        ArrayList<Object> copyRows = new ArrayList<Object>(dedupeRowMap.values());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TableInfo tableInfo = this.tableInfo.get(schemaNameTableName);
        List<ColumnInfo> primaryKeys = tableInfo.getPrimaryKeyColumns();
        List<String> userInputColumns = this.databaseConfig.getColumns(tableName, schemaName);
        ArrayList<Integer> primaryKeysIndex = new ArrayList<Integer>();
        for (String primaryKey : tableInfo.getPrimaryKeyColumnsNames()) {
            primaryKeysIndex.add(userInputColumns.indexOf(primaryKey));
        }
        String table = "\"" + this.databaseConfig.getDatabase() + "\"" + DOT + "\"" + this.tableInfo.get(schemaNameTableName).getTableSchema() + "\"" + DOT + "\"" + tableName + "\"";
        String deleteSQLPrefix = String.format("DELETE FROM %s WHERE ", table);
        Connection conn1 = null;
        Iterator iterator = copyRows.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            String copyString = this.generateCopyString(tableName, schemaName, row);
            byte[] rawData = copyString.getBytes(StandardCharsets.UTF_8);
            try {
                conn1 = this.getConnectionWithSetting();
                byteArrayOutputStream.write(rawData);
                this.executeCopy(byteArrayOutputStream, schemaNameTableName, userInputTableColumns, conn1);
                continue;
            }
            catch (SQLException e) {
                String errorMessage = e.getMessage();
                if (errorMessage != null) {
                    errorMessage = errorMessage.replaceAll("\\s", "");
                }
                Connection connection = null;
                PreparedStatement pstmt = null;
                if ((errorMessage.contains(PRIMARY_CONFLICT_ERROR_MSG_4_3_VERSION) || errorMessage.contains(PRIMARY_CONFLICT_ERROR_CODE_6_0_VERSION) || errorMessage.contains(PRIMARY_CONFLICT_ERROR_MSG_6_0_VERSION)) && !primaryKeys.isEmpty()) {
                    try {
                        String[] values = this.csvParser.parseLine(copyString.substring(0, copyString.length() - IOUtils.LINE_SEPARATOR.length()));
                        StringBuilder deleteSqlsb = new StringBuilder();
                        deleteSqlsb.append(deleteSQLPrefix);
                        int p = 0;
                        for (Integer i : primaryKeysIndex) {
                            if (p != 0) {
                                deleteSqlsb.append(String.format("AND %s = ? ", "\"" + userInputColumns.get(i) + "\""));
                            } else {
                                deleteSqlsb.append(String.format("%s = ? ", "\"" + userInputColumns.get(i) + "\""));
                            }
                            ++p;
                        }
                        connection = this.getConnectionWithSetting();
                        connection.setAutoCommit(false);
                        pstmt = connection.prepareStatement(deleteSqlsb.toString());
                        block21: for (int j = 0; j < primaryKeysIndex.size(); ++j) {
                            int columnType = this.configColumnsMetaData.get(schemaNameTableName).get(userInputColumns.get((Integer)primaryKeysIndex.get(j))).getLeft();
                            switch (columnType) {
                                case 2: 
                                case 3: 
                                case 6: 
                                case 7: 
                                case 8: {
                                    pstmt.setBigDecimal(j + 1, new BigDecimal(values[(Integer)primaryKeysIndex.get(j)]));
                                    continue block21;
                                }
                                case -5: 
                                case 4: 
                                case 5: {
                                    pstmt.setLong(j + 1, Long.parseLong(values[(Integer)primaryKeysIndex.get(j)]));
                                    continue block21;
                                }
                                default: {
                                    pstmt.setString(j + 1, values[(Integer)primaryKeysIndex.get(j)]);
                                }
                            }
                        }
                        pstmt.executeUpdate();
                        this.executeCopy(byteArrayOutputStream, schemaNameTableName, userInputTableColumns, connection);
                        connection.commit();
                        connection.setAutoCommit(true);
                        this.closeDBResources(null, pstmt, connection);
                        continue;
                    }
                    catch (SQLException e1) {
                        try {
                            throw new Adb4pgClientException(102, "Delete the violation row Error: " + e1.getMessage(), (Throwable)e);
                            catch (Exception e2) {
                                throw new Adb4pgClientException(102, "Override Row Error: " + e2.getMessage(), (Throwable)e2);
                            }
                        }
                        catch (Throwable throwable) {
                            this.closeDBResources(null, pstmt, connection);
                            throw throwable;
                        }
                    }
                }
                this.commitExceptionDataList.add(copyString);
                this.exception = e;
                continue;
            }
            catch (Exception e) {
                throw new Adb4pgClientException(102, "Override Row Error: " + e.getMessage() + e.getCause(), (Throwable)e);
            }
            finally {
                this.closeDBResources(null, null, conn1);
                byteArrayOutputStream.reset();
                continue;
            }
            break;
        }
        return;
    }

    private void initDatasource() {
        if (this.dataSource != null) {
            Connection testConn = null;
            try {
                testConn = this.getConnectionWithSetting();
            }
            finally {
                this.closeDBResources(null, null, testConn);
            }
            return;
        }
        if (this.databaseConfig.isShareDataSource()) {
            this.dataSource = this.clientDataSource.getDataSource(this.databaseConfig);
            return;
        }
        this.dataSource = this.clientDataSource.newDataSource(this.databaseConfig);
    }

    private Boolean initInstance() {
        this.tableInfo = new ConcurrentHashMap<String, TableInfo>(16);
        this.isAllColumn = new HashMap<String, Boolean>(16);
        this.configColumnsMetaData = new HashMap<String, Map<String, Pair<Integer, String>>>(16);
        this.tableColumnsMetaData = new HashMap<String, Map<String, Pair<Integer, String>>>(16);
        for (String tableName : this.databaseConfig.getTable()) {
            this.isAllColumn.put(tableName, false);
        }
        this.dataBuffer = new HashMap<String, Map<String, Row>>();
        this.preHashDataBuffer = new HashMap<String, Map<Integer, Map<String, Row>>>();
        this.bufferTableSize = new HashMap<String, Long>();
        this.checkConfig();
        this.logger(INFO, "init adb client successfully");
        this.startScheduler(this.databaseConfig.getDatabase(), this.databaseConfig.getTable(), this.getConnectionWithSetting());
        return true;
    }

    private Boolean checkConfig() {
        try {
            this.checkDatabaseConfig();
            this.getTableInfo(this.databaseConfig.getDatabase(), this.databaseConfig.getTable(), this.getConnectionWithSetting());
            for (String schemaNameTableName : this.databaseConfig.getTable()) {
                this.checkTableConfig(schemaNameTableName);
            }
            if (!this.databaseConfig.isInsertIgnore()) {
                this.checkCopyOnConflict();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Adb4pgClientException(106, "Check config exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void refreshTableInfo(String tablename, String schemaname) {
        TableInfo info = this.getTableInfo(tablename, schemaname);
        this.databaseConfig.setColumns(info.getColumnsNames(), tablename, schemaname);
        this.checkTableConfig(schemaname + DOT + tablename);
    }

    private void checkTableConfig(String schemaNameTableName) {
        TableInfo tableInfoTmp = this.tableInfo.get(schemaNameTableName);
        if (tableInfoTmp == null) {
            return;
        }
        String[] s2 = schemaNameTableName.split("\\.");
        this.dealColumnConf(s2[0], s2[1]);
        Map<String, Pair<Integer, String>> columnMetaData = this.getColumnMetaData(tableInfoTmp);
        this.tableColumnsMetaData.put(schemaNameTableName, columnMetaData);
        HashMap<String, Pair<Integer, String>> configColumnMetaDataTmp = new HashMap<String, Pair<Integer, String>>(16);
        for (int i = 0; i < this.databaseConfig.getColumns(s2[1], s2[0]).size(); ++i) {
            String oriEachColumn = this.databaseConfig.getColumns(s2[1], s2[0]).get(i);
            String eachColumn = oriEachColumn;
            if (eachColumn.startsWith("\"") && eachColumn.endsWith("\"")) {
                eachColumn = eachColumn.substring(1, eachColumn.length() - 1);
            }
            for (String eachAdsColumn : tableInfoTmp.getColumnsNames()) {
                if (!eachColumn.equalsIgnoreCase(eachAdsColumn)) continue;
                configColumnMetaDataTmp.put(oriEachColumn, this.tableColumnsMetaData.get(schemaNameTableName).get(eachAdsColumn));
            }
        }
        this.configColumnsMetaData.put(schemaNameTableName, configColumnMetaDataTmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCopyOnConflict() {
        Statement statement = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnectionWithSetting();
            statement = connection.createStatement();
            rs = statement.executeQuery("show rds_enable_copy_on_conflict");
            rs.next();
            this.copyOnConflict = true;
            this.closeDBResources(rs, statement, connection);
        }
        catch (Exception e) {
            try {
                this.copyOnConflict = false;
                this.logger(INFO, "current version doesn't support copy on conflict feature, please do upgrade operation");
                this.closeDBResources(rs, statement, connection);
            }
            catch (Throwable throwable) {
                this.closeDBResources(rs, statement, connection);
                throw throwable;
            }
        }
    }

    private Map<String, Pair<Integer, String>> getColumnMetaData(TableInfo tableInfo) {
        HashMap<String, Pair<Integer, String>> columnMetaData = new HashMap<String, Pair<Integer, String>>(16);
        List<ColumnInfo> columnInfoList = tableInfo.getColumns();
        int i = 0;
        for (ColumnInfo columnInfo : columnInfoList) {
            if (columnInfo.getDataType() == null) {
                throw new Adb4pgClientException(106, "The column info is not support, please check, column index is " + i, null);
            }
            ImmutablePair<Integer, String> eachPair = new ImmutablePair<Integer, String>(columnInfo.getDataType().sqlType, columnInfo.getDataType().name);
            columnMetaData.put(columnInfo.getName(), eachPair);
            ++i;
        }
        return columnMetaData;
    }

    private void dealColumnConf(String schemaName, String tableName) {
        List<String> userConfiguredColumns = this.databaseConfig.getColumns(tableName, schemaName);
        List<String> tableAllColumnsNames = this.tableInfo.get(schemaName + DOT + tableName).getColumnsNames();
        if (null == userConfiguredColumns || userConfiguredColumns.isEmpty()) {
            throw new Adb4pgClientException(106, "Config is error. Do not have column list", null);
        }
        if (1 == userConfiguredColumns.size() && ALL_COLUMN_CHARACTER.equals(userConfiguredColumns.get(0))) {
            this.isAllColumn.put(schemaName + DOT + tableName, true);
            this.databaseConfig.setColumns(tableAllColumnsNames, tableName, schemaName);
        } else {
            if (userConfiguredColumns.size() > tableAllColumnsNames.size()) {
                throw new Adb4pgClientException(106, String.format("Database config is error. The count of writer columns %s is bigger than the count of read table's columns {}.", userConfiguredColumns.size(), tableAllColumnsNames.size()), null);
            }
            Adb4pgClient.makeSureNoValueDuplicate(userConfiguredColumns, false);
            ArrayList<String> removeQuotedColumns = new ArrayList<String>();
            for (String each : userConfiguredColumns) {
                if (each.startsWith("\"") && each.endsWith("\"")) {
                    removeQuotedColumns.add(each.substring(1, each.length() - 1));
                    continue;
                }
                removeQuotedColumns.add(each);
            }
            Adb4pgClient.makeSureBInA(tableAllColumnsNames, removeQuotedColumns, false);
        }
    }

    private void checkDatabaseConfig() {
        String[] s2;
        if (this.databaseConfig.getTable() == null || this.databaseConfig.getTable().isEmpty()) {
            throw new RuntimeException("Table can not be null");
        }
        for (String schemaNameTableName : this.databaseConfig.getTable()) {
            s2 = schemaNameTableName.split("\\.");
            if (this.schemaNameTableNameCache.get(s2[0]) == null) {
                this.schemaNameTableNameCache.put(s2[0], new HashMap(16));
            }
            this.schemaNameTableNameCache.get(s2[0]).put(s2[1], s2[0] + DOT + s2[1]);
        }
        this.databaseConfig.setSchemaNameTableNameCache(this.schemaNameTableNameCache);
        for (String schemaNameTableName : this.databaseConfig.getTable()) {
            s2 = schemaNameTableName.split("\\.");
            if (this.databaseConfig.getColumns(s2[1], s2[0]) != null) continue;
            throw new RuntimeException(String.format("Columns of table %s can not be null", schemaNameTableName));
        }
        if (this.databaseConfig.getHost() == null) {
            throw new RuntimeException("Host can not be null");
        }
        if (this.databaseConfig.getDatabase() == null) {
            throw new RuntimeException("Database can not be null");
        }
        if (this.databaseConfig.getPassword() == null) {
            throw new RuntimeException("Password can not be null");
        }
        if (this.databaseConfig.getUser() == null) {
            throw new RuntimeException("Username can not be null");
        }
        if (this.databaseConfig.getPort() == 0) {
            throw new RuntimeException("Port can not be 0");
        }
        if (this.databaseConfig.getEmptyAsNull() == null) {
            throw new RuntimeException("EmptyAsNull can not be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ColumnInfo> getTablePrimaryKeys(Connection connection, String catalog, String schema, String table) throws SQLException {
        ArrayList<ColumnInfo> primaryKeyColumns = new ArrayList<ColumnInfo>();
        DatabaseMetaData dbMetaData = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            dbMetaData = connection.getMetaData();
            rs = dbMetaData.getPrimaryKeys(catalog, schema, table);
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                List<ColumnInfo> columnsInfo = this.getColumnsInfo(table, schema);
                if (columnsInfo == null) {
                    this.logger(ERROR, "GetPrimaryKeys error: " + columnName + " is not existed");
                }
                for (ColumnInfo columnInfo : columnsInfo) {
                    if (!columnInfo.getName().equals(columnName)) continue;
                    primaryKeyColumns.add(columnInfo);
                }
            }
            this.closeDBResources(rs, statement, null);
        }
        catch (Throwable throwable) {
            this.closeDBResources(rs, statement, null);
            throw throwable;
        }
        return primaryKeyColumns;
    }

    private List<ColumnInfo> getPrimaryKeyColumn(String schema, String table, String columnName) {
        return this.getTableInfo(table, schema).getPrimaryKeyColumns();
    }

    public Connection getConnection() {
        int retryNum = 0;
        Exception ex = null;
        while (retryNum <= this.databaseConfig.getRetryTimes()) {
            try {
                return this.dataSource.getConnection(60000L);
            }
            catch (Exception e) {
                ex = e;
                this.logger(ERROR, "Create connection error after " + retryNum + " times retry " + e.getMessage());
                ++retryNum;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.databaseConfig.getRetryIntervalTime());
                }
                catch (InterruptedException e2) {
                    this.logger(ERROR, "create connection error " + e2.getMessage());
                }
            }
        }
        throw new Adb4pgClientException(104, "Creating connection failed", (Throwable)ex);
    }

    private Connection getConnectionWithSetting() {
        int retryNum = 0;
        Exception ex = null;
        while (retryNum <= this.databaseConfig.getRetryTimes()) {
            try {
                DruidPooledConnection res = this.dataSource.getConnection(5000L);
                Statement statement = res.createStatement();
                statement.executeUpdate(SET_AUTOSTATS_MODE_OFF);
                statement.executeUpdate(SET_OPTIMIZER_OFF_SQL);
                statement.executeUpdate(SET_SEQSCAN_OFF_SQL);
                return res;
            }
            catch (Exception e) {
                ex = e;
                this.logger(ERROR, "Create connection error after " + retryNum + " times retry " + e.getMessage());
                ++retryNum;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.databaseConfig.getRetryIntervalTime());
                }
                catch (InterruptedException e2) {
                    this.logger(ERROR, "create connection error " + e2.getMessage());
                }
            }
        }
        throw new Adb4pgClientException(104, "Creating statement and connection failed", (Throwable)ex);
    }

    private void logger(String level, String msg) {
        if (this.databaseConfig.getLogger() != null) {
            if (INFO.equals(level)) {
                this.databaseConfig.getLogger().info("Adb4PGClient info: {}", (Object)msg);
            } else if (ERROR.equals(level)) {
                this.databaseConfig.getLogger().error("Adb4PGClient error: {}", (Object)msg);
            }
        }
    }

    private void closeDBResources(ResultSet rs, Statement stmt, Connection conn) {
        ArrayList<String> errList = new ArrayList<String>();
        if (null != rs) {
            try {
                rs.close();
            }
            catch (Exception e) {
                errList.add("Close ResultSet occur SQLException " + e.getMessage());
            }
        }
        if (null != stmt) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                errList.add("Close Statement occur SQLException " + e.getMessage());
            }
        }
        if (null != conn) {
            try {
                if (conn.getWarnings() != null) {
                    conn.clearWarnings();
                }
                conn.close();
            }
            catch (Exception e) {
                errList.add("Close Connection occur SQLException " + e.getMessage());
            }
        }
        if (!errList.isEmpty()) {
            throw new Adb4pgClientException(105, ((Object)errList).toString(), null);
        }
    }

    private static void makeSureNoValueDuplicate(List<String> aList, boolean caseSensitive) {
        if (null == aList || aList.isEmpty()) {
            throw new RuntimeException("Column can not be null");
        }
        if (1 == aList.size()) {
            return;
        }
        List<String> list = null;
        list = !caseSensitive ? Adb4pgClient.valueToLowerCase(aList) : new ArrayList<String>(aList);
        Collections.sort(list);
        int len = list.size() - 1;
        for (int i = 0; i < len; ++i) {
            if (!list.get(i).equals(list.get(i + 1))) continue;
            throw new RuntimeException(String.format("The column %s in config must be uniq", list.get(i)));
        }
    }

    private static List<String> valueToLowerCase(List<String> aList) {
        if (null == aList || aList.isEmpty()) {
            throw new RuntimeException("Column can not be null");
        }
        ArrayList<String> result = new ArrayList<String>(aList.size());
        for (String oneValue : aList) {
            result.add(null != oneValue ? oneValue.toLowerCase() : null);
        }
        return result;
    }

    private static void makeSureBInA(List<String> aList, List<String> bList, boolean caseSensitive) {
        if (null == aList || aList.isEmpty() || null == bList || bList.isEmpty()) {
            throw new RuntimeException("Column can not be null");
        }
        List<String> all = null;
        List<String> part = null;
        if (!caseSensitive) {
            all = Adb4pgClient.valueToLowerCase(aList);
            part = Adb4pgClient.valueToLowerCase(bList);
        } else {
            all = new ArrayList<String>(aList);
            part = new ArrayList<String>(bList);
        }
        for (String oneValue : part) {
            if (all.contains(oneValue)) continue;
            throw new RuntimeException(String.format("The column %s is not exist in table", oneValue));
        }
    }

    private String convertDate(String columnValue) throws SQLException {
        java.util.Date utilDate;
        try {
            utilDate = Date.valueOf(columnValue);
            if (utilDate == null) {
                utilDate = new SimpleDateFormat("yyyy-MM-dd").parse(columnValue);
            }
        }
        catch (Exception e) {
            throw new SQLException(String.format("Date transform error\uff1a[%s]", columnValue), e);
        }
        if (utilDate == null) {
            throw new SQLException(String.format("Date transform error\uff1a[%s]", columnValue));
        }
        return ((java.util.Date)utilDate).toString();
    }

    private String convertTime(String columnValue) throws SQLException {
        Time sqlTime = null;
        try {
            sqlTime = Time.valueOf(columnValue);
            return sqlTime.toString();
        }
        catch (Exception e) {
            throw new SQLException(String.format("TIME transform error\uff1a[%s]", columnValue), e);
        }
    }

    private String convertTimeStamp(String columnValue) throws SQLException {
        Timestamp sqlTimestamp;
        try {
            sqlTimestamp = Timestamp.valueOf(columnValue);
        }
        catch (Exception e) {
            throw new SQLException(String.format("TIMESTAMP transform error\uff1a[%s]", columnValue), e);
        }
        return sqlTimestamp.toString();
    }

    private String convertArray(Object columnObject) throws SQLException {
        if (!columnObject.getClass().isArray()) {
            throw new SQLException(String.format("Array transform error: [%s]", columnObject.toString()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int size = Array.getLength(columnObject);
        Class<?> componentType = columnObject.getClass().getComponentType();
        for (int i = 0; i < size; ++i) {
            Object element = Array.get(columnObject, i);
            if (componentType.equals(Timestamp.class)) {
                sb.append(this.convertTimeStamp(element.toString()));
            } else if (componentType.equals(Time.class)) {
                sb.append(this.convertTime(element.toString()));
            } else if (componentType.equals(java.util.Date.class)) {
                sb.append(this.convertDate(element.toString()));
            } else if (componentType.equals(String.class)) {
                sb.append("\"");
                sb.append(this.escapeString(element.toString()));
                sb.append("\"");
            } else {
                sb.append(element.toString());
            }
            if (i == size - 1) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    private String dataConvertor(int columnSqlType, Object columnObject, String schemaNameTableName, String columnName) throws SQLException {
        boolean isEmpty;
        if (columnObject == null) {
            return null;
        }
        String value = columnObject.toString();
        boolean bl = isEmpty = this.databaseConfig.getEmptyAsNull() != false && "".equals(value);
        if (isEmpty) {
            return null;
        }
        switch (columnSqlType) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return value;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 16: 
            case 1111: 
            case 2005: 
            case 2011: {
                return this.escapeString(value);
            }
            case 2003: {
                return this.escapeString(this.convertArray(columnObject));
            }
            case -2: {
                return PGbytea.toPGString(value.getBytes());
            }
        }
        return this.escapeString(value);
    }

    private Row mapToRow(Map<String, String> dataMap, String tableName, String schemaName) {
        List<String> userConfigColumn = this.databaseConfig.getColumns(tableName, schemaName);
        Row row = new Row();
        for (int k = 0; k < userConfigColumn.size(); ++k) {
            row.setColumn(k, null);
        }
        int i = 0;
        String schemaNameTableName = this.schemaNameTableNameCache.get(schemaName).get(tableName);
        for (ColumnInfo ci : this.tableInfo.get(schemaNameTableName).getColumns()) {
            if (!this.isAllColumn.get(schemaNameTableName).booleanValue()) {
                i = this.databaseConfig.getColumns(tableName, schemaName).indexOf(ci.getName());
            }
            if (dataMap.get(ci.getName()) != null) {
                row.updateColumn(i, dataMap.get(ci.getName()));
                dataMap.remove(ci.getName());
            } else {
                if (!ci.isNullable()) {
                    throw new Adb4pgClientException(103, String.format("The column %s of table %s can not be null", ci.getName(), tableName), null);
                }
                row.updateColumn(i, ci.getDefaultValue());
            }
            if (!this.isAllColumn.get(schemaNameTableName).booleanValue()) continue;
            ++i;
        }
        if (dataMap.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> e : dataMap.entrySet()) {
                sb.append(e.getKey());
                sb.append(" ");
            }
            throw new Adb4pgClientException(103, String.format("The columns %s do not exit in table %s or not be configured", sb, schemaName + DOT + tableName), null);
        }
        return row;
    }

    public void stop() {
        if (!this.dataBuffer.isEmpty() && this.commitExceptionDataList.isEmpty()) {
            throw new Adb4pgClientException(107, "Batch data do not commit, please commit first", null);
        }
        this.forceStop();
    }

    public void forceStop() {
        this.executorService.shutdown();
        if (this.dataBuffer != null) {
            this.dataBuffer.clear();
        }
        this.tableInfo.clear();
        this.tableColumnsMetaData.clear();
        this.configColumnsMetaData.clear();
        this.dataSource.close();
    }

    private String escapeString(String input) {
        if (null == input) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\' || c == '\"') {
                sb.append('\\');
            } else if (c == '\u0000') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public void startScheduler(final String userInputDatabase, final List<String> userInputTables, Connection connection) {
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    Adb4pgClient.this.logger(Adb4pgClient.INFO, "refreshing table metadata");
                    Adb4pgClient.this.getTableInfo(userInputDatabase, userInputTables, Adb4pgClient.this.dataSource.getConnection(), true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 0L, this.databaseConfig.getMetaDataSchedulerInterval(), TimeUnit.MINUTES);
    }

    public void stopScheduler() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
                if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Scheduler did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    protected int getTableSegmentNumber(Connection connection, String tableName, String targetSchema) {
        int segmentNumber = 0;
        try {
            String sql = String.format("SELECT numsegments from gp_distribution_policy where localoid = '\"%s\".\"%s\"'::regclass", targetSchema, tableName);
            Statement statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            if (rs.next()) {
                segmentNumber = rs.getInt("numsegments");
            }
            statement.close();
            rs.close();
        }
        catch (SQLException e) {
            throw new Adb4pgClientException(999, "Get Table segment number failed", (Throwable)e);
        }
        return segmentNumber;
    }

    protected List<ColumnInfo> getShardKeys(Connection connection, String tableName, String targetSchema) {
        ArrayList<ColumnInfo> shardKeys = new ArrayList<ColumnInfo>();
        try {
            String sql = String.format("SELECT dp.distkey, string_agg(a.attname, ' ') AS distkeyname, dp.numsegments\n  FROM  gp_distribution_policy dp\n  JOIN pg_class c ON dp.localoid = c.oid\n  JOIN pg_attribute a ON c.oid = a.attrelid\n  WHERE c.relname = '%s' AND c.relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = '%s') AND\n  a.attnum = ANY(dp.distkey) GROUP BY dp.distkey, dp.numsegments;", tableName, targetSchema);
            Statement statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            if (rs.next()) {
                String distKeyStr = rs.getString("distkey");
                String distKeyNameStr = rs.getString("distkeyname");
                if (distKeyStr != null && !distKeyStr.trim().isEmpty()) {
                    List shardKeyOrdinalList = Arrays.stream(distKeyStr.trim().split("\\s+")).collect(Collectors.toList());
                    List shardKeyNameList = Arrays.stream(distKeyNameStr.trim().split("\\s+")).collect(Collectors.toList());
                    if (shardKeyOrdinalList.size() != shardKeyNameList.size()) {
                        throw new Adb4pgClientException(999, "Get Shard key failed", null);
                    }
                    for (int i = 0; i < shardKeyNameList.size(); ++i) {
                        ColumnInfo column = new ColumnInfo();
                        column.setName((String)shardKeyNameList.get(i));
                        column.setOrdinal(Integer.parseInt((String)shardKeyOrdinalList.get(i)));
                        shardKeys.add(column);
                    }
                }
            }
            rs.close();
            statement.close();
        }
        catch (SQLException e) {
            throw new Adb4pgClientException(999, "Get Shard key failed", (Throwable)e);
        }
        return shardKeys;
    }

    public String[] getShardKeyValues(String schemaNameTableName, List<ColumnInfo> shardKeys, Row row, Map<String, Pair<Integer, String>> columnTypes) throws SQLException {
        String[] shardKeyValue = new String[shardKeys.size()];
        List<Object> columnValues = row.getColumnValues();
        for (int i = 0; i < shardKeys.size(); ++i) {
            int columnOrdinal = shardKeys.get(i).getOrdinal();
            String columnName = shardKeys.get(i).getName();
            int columnSqlType = columnTypes.get(columnName).getLeft();
            shardKeyValue[i] = this.dataConvertor(columnSqlType, columnValues.get(columnOrdinal - 1), schemaNameTableName, columnName);
        }
        return shardKeyValue;
    }

    protected int[] getShardKeysIsNull(List<ColumnInfo> shardKeys, Row row) {
        int[] shardKeysIsNull = new int[shardKeys.size()];
        List<Object> columnValues = row.getColumnValues();
        for (int i = 0; i < shardKeys.size(); ++i) {
            int columnOrdinal = shardKeys.get(i).getOrdinal();
            shardKeysIsNull[i] = columnValues.get(columnOrdinal - 1) == null ? 1 : 0;
        }
        return shardKeysIsNull;
    }

    protected int[] getShardKeysType(List<ColumnInfo> shardKeys, Map<String, Pair<Integer, String>> columnTypes) {
        int[] shardKeysType = new int[shardKeys.size()];
        for (int i = 0; i < shardKeys.size(); ++i) {
            int columnSqlType;
            String columnName = shardKeys.get(i).getName();
            shardKeysType[i] = columnSqlType = columnTypes.get(columnName).getLeft().intValue();
        }
        return shardKeysType;
    }

    class Task {
        List<Row> outputRows;
        String schemaNameTableName;
        String schemaName;
        String tableName;
        List<String> tableColumns;

        Task(List<Row> outputRows, String tableName, String schemaName, String schemaNameTableName, List<String> tableColumns) {
            this.tableName = tableName;
            this.schemaName = schemaName;
            this.outputRows = outputRows;
            this.schemaNameTableName = schemaNameTableName;
            this.tableColumns = tableColumns;
        }
    }
}

