/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher.utils;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.launcher.models.Conf;
import org.apache.spark.launcher.models.SparkSubmit;

public class SparkSubmitOptionParser {
    private static final String DETAIL = "--detail";
    private static final String KILL = "--kill";
    private static final String LIST = "--list";
    private static final String STATUS = "--status";
    private static final String MAX_RESULTS = "--max-results";
    private static final String NEXT_TOKEN = "--next-token";
    private static final String CLASS = "--class";
    private static final String CONF = "--conf";
    private static final String NUM_EXECUTORS = "--num-executors";
    private static final String DRIVER_CORES = "--driver-cores";
    private static final String DRIVER_MEMORY = "--driver-memory";
    private static final String EXECUTOR_CORES = "--executor-cores";
    private static final String EXECUTOR_MEMORY = "--executor-memory";
    private static final String FILES = "--files";
    private static final String JARS = "--jars";
    private static final String PY_FILES = "--py-files";
    private static final String ARCHIVES = "--archives";
    private static final String NAME = "--name";
    private static final String QUEUE = "--queue";
    private static final String DETACH = "--detach";
    private static final String SQLFILE = "-f";
    private static final String SQLEXPRESSION = "-e";
    private static final String SQLDEFINE = "-d";
    private static final String _SQLDEFINE = "--define";
    private static final String HIVEVAR = "--hivevar";
    private static final String _HIVEVAR = "-hivevar";
    private static final String RELEASE_VERSION = "--release-version";
    private static final String ENABLE_TEMPLATE = "--enable-template";
    private static final String TIMEOUT = "--timeout";
    private static final String PROXY_USER = "--proxy-user";
    private static final String REPOSITORIES = "--repositories";
    private static final String PACKAGES = "--packages";
    private static final String WORKSPACE_ID = "--workspace-id";
    private static final String ACCESS_KEY_ID = "--access-key-id";
    private static final String ACCESS_KEY_SECRET = "--access-key-secret";
    private static final String SECURITY_TOKEN = "--security-token";
    private static final String RAM_ROLE_NAME = "--ram-role-name";
    private static final String LOGS = "--logs";
    private static final String PRINCIPAL = "--principal";
    private static final String KEYTAB = "--keytab";
    private static final String TEMPLATE_NAME = "--template-name";
    static final String[][] opts = new String[][]{{"--archives"}, {"--class"}, {"--conf", "-c"}, {"--driver-cores"}, {"--driver-memory"}, {"--executor-cores"}, {"--executor-memory"}, {"--files"}, {"--jars"}, {"--num-executors"}, {"--py-files"}, {"--name"}, {"--queue"}, {"--detail"}, {"--detach"}, {"--kill"}, {"--list"}, {"--status"}, {"--max-results"}, {"--next-token"}, {"-f"}, {"-e"}, {"-d"}, {"--define"}, {"--hivevar"}, {"-hivevar"}, {"--release-version"}, {"--enable-template"}, {"--timeout"}, {"--proxy-user"}, {"--repositories"}, {"--packages"}, {"--workspace-id"}, {"--access-key-id"}, {"--access-key-secret"}, {"--security-token"}, {"--ram-role-name"}, {"--logs"}, {"--principal"}, {"--keytab"}, {"--template-name"}};
    static final List<String> noValueOpts = Arrays.asList("--list", "--detach", "--enable-template");

    public static SparkSubmit parse(List<String> args) {
        int idx;
        SparkSubmit sparkSubmit = new SparkSubmit();
        Pattern eqSeparatedOpt = Pattern.compile("(--[^=]+)=(.+)");
        for (idx = 0; idx < args.size(); ++idx) {
            String name;
            String arg = args.get(idx);
            String value = null;
            Matcher m = eqSeparatedOpt.matcher(arg);
            if (m.matches()) {
                arg = m.group(1);
                value = m.group(2);
            }
            if ((name = SparkSubmitOptionParser.findCliOption(arg)) != null) {
                if (noValueOpts.contains(name)) {
                    value = "";
                }
                if (value == null) {
                    if (idx == args.size() - 1) {
                        throw new IllegalArgumentException(String.format("Missing argument for option '%s'.", arg));
                    }
                    value = args.get(++idx);
                }
                SparkSubmitOptionParser.handle(sparkSubmit, name, value);
                continue;
            }
            if (!SparkSubmitOptionParser.handleUnknown(sparkSubmit, arg)) break;
        }
        if (idx < args.size()) {
            ++idx;
        }
        sparkSubmit.setExtraArgs(args.subList(idx, args.size()));
        return sparkSubmit;
    }

    private static void handle(SparkSubmit sparkSubmit, String opt, String value) {
        if (opt.equals(CONF)) {
            int idx = value.indexOf("=");
            if (idx <= 0 || idx == value.length() - 1) {
                return;
            }
            String confKey = value.substring(0, idx);
            String confValue = value.substring(idx + 1);
            if (confValue.startsWith("\"") && confValue.endsWith("\"") || confValue.startsWith("'") && confValue.endsWith("'")) {
                confValue = new Gson().fromJson(confValue, String.class);
            }
            if (confKey.equals("spark.driver.cores")) {
                sparkSubmit.setSparkDriverCores(Integer.parseInt(confValue));
            } else if (confKey.equals("spark.driver.memory")) {
                sparkSubmit.setSparkDriverMemory(confValue);
            } else if (confKey.equals("spark.executor.cores")) {
                sparkSubmit.setSparkExecutorCores(Integer.parseInt(confValue));
            } else if (confKey.equals("spark.executor.memory")) {
                sparkSubmit.setSparkExecutorMemory(confValue);
            } else if (confKey.equals("spark.executor.instances")) {
                sparkSubmit.setSparkNumExecutors(Integer.parseInt(confValue));
            } else if (confKey.equals("spark.archives") && sparkSubmit.getSparkArchives() == null) {
                sparkSubmit.setSparkArchives(confValue);
            } else if (confKey.equals("spark.files") && sparkSubmit.getSparkFiles() == null) {
                sparkSubmit.setSparkFiles(confValue);
            } else if (confKey.equals("spark.jars") && sparkSubmit.getSparkJars() == null) {
                sparkSubmit.setSparkJars(confValue);
            } else if (confKey.equals("spark.submit.pyFiles") && sparkSubmit.getSparkPyFiles() == null) {
                sparkSubmit.setSparkPyFiles(confValue);
            } else if (confKey.equals("spark.app.name") && sparkSubmit.getName() == null) {
                sparkSubmit.setName(confValue);
            } else {
                switch (confKey) {
                    case "spark.yarn.queue": {
                        sparkSubmit.setQueue(confValue);
                        break;
                    }
                    case "spark.emr.SKYNET_NODENAME": {
                        sparkSubmit.setDwNodeName(confValue);
                        break;
                    }
                    case "spark.emr.JR_TIMEOUT": {
                        sparkSubmit.setTimeout(Integer.parseInt(confValue));
                        break;
                    }
                    case "spark.emr.serverless.fusion.enabled": {
                        sparkSubmit.setFusion("true".equalsIgnoreCase(confValue));
                        break;
                    }
                    case "spark.emr.serverless.templateId": {
                        sparkSubmit.setTemplateBizId(confValue);
                        break;
                    }
                    case "spark.emr.serverless.templateName": {
                        sparkSubmit.setTemplateName(confValue);
                    }
                }
                sparkSubmit.getConf().add(Conf.builder().key(confKey).value(confValue).build());
            }
        } else {
            switch (opt) {
                case "--detail": 
                case "--kill": 
                case "--status": 
                case "--logs": {
                    sparkSubmit.setAction(opt.replace("--", "").toUpperCase());
                    sparkSubmit.setTargetJrId(value);
                    break;
                }
                case "--list": {
                    sparkSubmit.setAction("LIST");
                    break;
                }
                case "--detach": {
                    sparkSubmit.setDetach(true);
                    break;
                }
                case "--max-results": {
                    sparkSubmit.setMaxResults(Integer.parseInt(value));
                    break;
                }
                case "--next-token": {
                    sparkSubmit.setNextToken(value);
                    break;
                }
                case "--driver-cores": {
                    sparkSubmit.setSparkDriverCores(Integer.parseInt(value));
                    break;
                }
                case "--driver-memory": {
                    sparkSubmit.setSparkDriverMemory(value);
                    break;
                }
                case "--executor-cores": {
                    sparkSubmit.setSparkExecutorCores(Integer.parseInt(value));
                    break;
                }
                case "--executor-memory": {
                    sparkSubmit.setSparkExecutorMemory(value);
                    break;
                }
                case "--num-executors": {
                    sparkSubmit.setSparkNumExecutors(Integer.parseInt(value));
                    break;
                }
                case "--name": {
                    sparkSubmit.setName(value);
                    break;
                }
                case "--queue": {
                    sparkSubmit.setQueue(value);
                    break;
                }
                case "--archives": {
                    sparkSubmit.setSparkArchives(value);
                    break;
                }
                case "--files": {
                    sparkSubmit.setSparkFiles(value);
                    break;
                }
                case "--py-files": {
                    sparkSubmit.setSparkPyFiles(value);
                    break;
                }
                case "--jars": {
                    sparkSubmit.setSparkJars(value);
                    break;
                }
                case "-f": {
                    sparkSubmit.setSqlFile(value);
                    if (sparkSubmit.getName() != null) break;
                    String fileName = value.substring(value.lastIndexOf("/") + 1);
                    sparkSubmit.setName(fileName);
                    break;
                }
                case "--class": {
                    if (sparkSubmit.getName() == null) {
                        sparkSubmit.setName(value.replace(".", "_"));
                    }
                    sparkSubmit.getParams().put(opt, value);
                    break;
                }
                case "-e": {
                    sparkSubmit.setSqlExpression(value);
                    if (sparkSubmit.getName() != null) break;
                    sparkSubmit.setName(value.split(";")[0]);
                    break;
                }
                case "-d": 
                case "--define": 
                case "--hivevar": 
                case "-hivevar": {
                    sparkSubmit.getSqlDefines().add(value);
                    break;
                }
                case "--release-version": {
                    sparkSubmit.setReleaseVersion(value);
                    break;
                }
                case "--enable-template": {
                    sparkSubmit.setEnableTemplate(true);
                    break;
                }
                case "--timeout": {
                    sparkSubmit.setTimeout(Integer.parseInt(value));
                    break;
                }
                case "--proxy-user": {
                    sparkSubmit.setProxyUser(value);
                    break;
                }
                case "--repositories": {
                    sparkSubmit.getConf().add(Conf.builder().key("spark.jars.repositories").value(value).build());
                    break;
                }
                case "--packages": {
                    sparkSubmit.getConf().add(Conf.builder().key("spark.jars.packages").value(value).build());
                    break;
                }
                case "--workspace-id": {
                    sparkSubmit.setWorkspaceId(value);
                    break;
                }
                case "--access-key-id": {
                    sparkSubmit.setAccessKeyId(value);
                    break;
                }
                case "--access-key-secret": {
                    sparkSubmit.setAccessKeySecret(value);
                    break;
                }
                case "--security-token": {
                    sparkSubmit.setSecurityToken(value);
                    break;
                }
                case "--ram-role-name": {
                    sparkSubmit.setRamRoleName(value);
                    break;
                }
                case "--keytab": {
                    sparkSubmit.setKeytab(value);
                    break;
                }
                case "--principal": {
                    sparkSubmit.setPrincipal(value);
                    break;
                }
                case "--template-name": {
                    sparkSubmit.setTemplateName(value);
                    break;
                }
                default: {
                    sparkSubmit.getParams().put(opt, value);
                }
            }
        }
    }

    private static boolean handleUnknown(SparkSubmit sparkSubmit, String opt) {
        if (opt.endsWith(".py") || opt.endsWith(".jar") || opt.endsWith(".ipynb") || opt.endsWith(".IPYNB")) {
            sparkSubmit.setAppResource(opt);
            return false;
        }
        return true;
    }

    private static String findCliOption(String name) {
        String[][] stringArray = opts;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] candidates;
            for (String candidate : candidates = stringArray[i]) {
                if (!candidate.equals(name)) continue;
                return candidates[0];
            }
        }
        return null;
    }
}

