/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher.log;

import java.util.function.Supplier;
import org.apache.spark.launcher.log.Logger;
import org.apache.spark.launcher.utils.DateUtil;

public class SimpleLogger
implements Logger {
    private static boolean DEBUG_MODE;
    private String prefix;

    public SimpleLogger(Class clazz) {
        this.prefix = String.format("[%-22s]", clazz.getSimpleName());
    }

    @Override
    public void turnOnDebug() {
        DEBUG_MODE = true;
    }

    @Override
    public void info(String message) {
        System.err.println(">>> [" + DateUtil.formatDate(System.currentTimeMillis()) + "][INFO   ]" + this.prefix + ": " + message);
    }

    @Override
    public void info(String message, Exception e) {
        this.info(message);
        if (e != null) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void warning(String message) {
        System.err.println(">>> [" + DateUtil.formatDate(System.currentTimeMillis()) + "][WARN   ]" + this.prefix + ": " + message);
    }

    @Override
    public void debug(Supplier<String> supplier) {
        if (DEBUG_MODE) {
            System.err.println(">>> [" + DateUtil.formatDate(System.currentTimeMillis()) + "][DEBUG]" + this.prefix + ": " + supplier.get());
        }
    }

    @Override
    public void debug(String message) {
        if (DEBUG_MODE) {
            System.err.println(">>> [" + DateUtil.formatDate(System.currentTimeMillis()) + "][DEBUG]" + this.prefix + ": " + message);
        }
    }

    @Override
    public void infoRaw(String message) {
        System.err.println(message);
    }

    @Override
    public void infoRawInLine(String message) {
        System.err.print(message);
    }
}

