/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.util.Arrays;
import org.apache.spark.launcher.ServerlessSparkUtil;
import org.apache.spark.launcher.models.SparkSubmit;
import org.apache.spark.launcher.utils.SparkSubmitOptionParser;

public class ServerlessSparkSubmitMain {
    public static void main(String[] args) throws Exception {
        SparkSubmit sparkSubmit = SparkSubmitOptionParser.parse(Arrays.asList(args));
        String packageVersion = ServerlessSparkSubmitMain.class.getPackage().getImplementationVersion();
        sparkSubmit.setToolVersion(packageVersion == null ? "dev-version" : packageVersion);
        ServerlessSparkUtil.loadConnection();
        if (sparkSubmit.getWorkspaceId() != null) {
            ServerlessSparkUtil.serverlessSparkConnection.setWorkspaceId(sparkSubmit.getWorkspaceId());
        }
        switch (sparkSubmit.getAction()) {
            case "SUBMIT": {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    if (sparkSubmit.getTargetJrId() != null && !sparkSubmit.getDetach().booleanValue()) {
                        ServerlessSparkUtil.cancelJobRun(sparkSubmit);
                    }
                    ServerlessSparkUtil.removeUserFiles();
                }));
                ServerlessSparkUtil.submitAndPoll(sparkSubmit);
                break;
            }
            case "DETAIL": {
                ServerlessSparkUtil.getJobRun(sparkSubmit);
                break;
            }
            case "STATUS": {
                ServerlessSparkUtil.getJobRunState(sparkSubmit);
                break;
            }
            case "KILL": {
                ServerlessSparkUtil.cancelJobRun(sparkSubmit);
                break;
            }
            case "LIST": {
                ServerlessSparkUtil.listJobRuns(sparkSubmit);
                break;
            }
            case "LOGS": {
                ServerlessSparkUtil.logJobRun(sparkSubmit);
                break;
            }
        }
        System.exit(ServerlessSparkUtil.returnCode);
    }
}

