/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.teautil;

import com.aliyun.tea.TeaModel;
import com.aliyun.tea.utils.StringUtils;
import com.aliyun.teautil.MapTypeAdapter;
import com.aliyun.teautil.models.TeaUtilException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;

public class Common {
    private static final String defaultUserAgent;
    private static AtomicLong seqId;
    private static final long processStartTime;

    public static byte[] toBytes(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TeaUtilException(e.getMessage(), e);
        }
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TeaUtilException(e.getMessage(), e);
        }
    }

    public static Object parseJSON(String json) {
        Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<Map<String, Object>>(){}.getType(), new MapTypeAdapter()).create();
        JsonElement jsonElement = gson.fromJson(json, JsonElement.class);
        return jsonElement.isJsonArray() ? gson.fromJson(json, List.class) : gson.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
    }

    public static Map<String, Object> assertAsMap(Object object) {
        if (null != object && Map.class.isAssignableFrom(object.getClass())) {
            return (Map)object;
        }
        throw new TeaUtilException("The value is not a object");
    }

    public static List<Object> assertAsArray(Object object) {
        if (null != object && List.class.isAssignableFrom(object.getClass())) {
            return (List)object;
        }
        throw new TeaUtilException("The value is not a array");
    }

    public static InputStream assertAsReadable(Object value) {
        if (null != value && InputStream.class.isAssignableFrom(value.getClass())) {
            return (InputStream)value;
        }
        throw new TeaUtilException("The value is not a readable");
    }

    public static byte[] assertAsBytes(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        throw new TeaUtilException("The value is not a byteArray");
    }

    public static Number assertAsNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new TeaUtilException("The value is not a Number");
    }

    public static Integer assertAsInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new TeaUtilException("The value is not a Integer");
    }

    public static String assertAsString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        throw new TeaUtilException("The value is not a String");
    }

    public static Boolean assertAsBoolean(Object object) {
        try {
            return (Boolean)object;
        }
        catch (Exception e) {
            throw new TeaUtilException("The value is not a Boolean");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readAsBytes(InputStream stream) {
        try {
            if (null == stream) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            while (true) {
                int read;
                if ((read = stream.read(buff)) == -1) {
                    byte[] byArray = os.toByteArray();
                    return byArray;
                }
                os.write(buff, 0, read);
                continue;
                break;
            }
        }
        catch (Exception e) {
            throw new TeaUtilException(e.getMessage(), e);
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new TeaUtilException(e.getMessage(), e);
                }
            }
        }
    }

    public static String readAsString(InputStream stream) {
        try {
            return new String(Common.readAsBytes(stream), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TeaUtilException(e.getMessage(), e);
        }
    }

    public static Object readAsJSON(InputStream stream) {
        String body = Common.readAsString(stream);
        try {
            return Common.parseJSON(body);
        }
        catch (Exception exception) {
            throw new TeaUtilException("Error: convert to JSON, response is:\n" + body);
        }
    }

    public static String getNonce() {
        long threadId = Thread.currentThread().getId();
        long currentTime = System.currentTimeMillis();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long seq = seqId.getAndIncrement();
        long rand = random.nextLong();
        StringBuffer sb = new StringBuffer();
        sb.append(processStartTime).append('-').append(threadId).append('-').append(currentTime).append('-').append(seq).append('-').append(rand);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] msg = sb.toString().getBytes();
            sb.setLength(0);
            for (byte b : digest.digest(msg)) {
                String hex = Integer.toHexString(b & 0xFF);
                if (hex.length() < 2) {
                    sb.append(0);
                }
                sb.append(hex);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new TeaUtilException(e.getMessage(), e);
        }
        return sb.toString();
    }

    public static String getDateUTCString() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(new Date());
    }

    public static String defaultString(String str, String defaultStr) {
        if (!StringUtils.isEmpty(str)) {
            return str;
        }
        return defaultStr;
    }

    public static Number defaultNumber(Number number, Number defaultNumber) {
        if (number != null && number.doubleValue() >= 0.0) {
            return number;
        }
        return defaultNumber;
    }

    public static String toFormString(Map<String, ?> map) {
        if (null == map) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        try {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                if (StringUtils.isEmpty(entry.getValue())) continue;
                if (first) {
                    first = false;
                } else {
                    result.append("&");
                }
                result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8"));
            }
        }
        catch (Exception e) {
            throw new TeaUtilException(e.getMessage(), e);
        }
        return result.toString();
    }

    public static String toJSONString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson(object);
    }

    public static boolean empty(String str) {
        return StringUtils.isEmpty(str);
    }

    public static boolean equalString(String str, String val) {
        if (str == null || val == null) {
            return false;
        }
        return str.equals(val);
    }

    public static boolean equalNumber(Number num, Number val) {
        if (num == null || val == null) {
            return false;
        }
        return num.doubleValue() == val.doubleValue();
    }

    public static boolean isUnset(Object object) {
        return null == object;
    }

    public static Map<String, String> stringifyMapValue(Map<String, ?> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null == map) {
            return null;
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (null == entry.getValue()) continue;
            result.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return result;
    }

    public static Map<String, Object> anyifyMapValue(Map<String, ?> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (null == map) {
            return null;
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static String getUserAgent(String val) {
        if (StringUtils.isEmpty(val)) {
            return defaultUserAgent;
        }
        return defaultUserAgent + " " + val;
    }

    public static boolean is2xx(Number code) {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 200 && code.intValue() < 300;
    }

    public static boolean is3xx(Number code) {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 300 && code.intValue() < 400;
    }

    public static boolean is4xx(Number code) {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 400 && code.intValue() < 500;
    }

    public static boolean is5xx(Number code) {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 500 && code.intValue() < 600;
    }

    public static void validateModel(TeaModel m) {
        if (null == m) {
            throw new TeaUtilException("parameter is not allowed as null");
        }
        try {
            m.validate();
        }
        catch (Exception e) {
            throw new TeaUtilException(e.getMessage(), e);
        }
    }

    public static Map<String, Object> toMap(TeaModel in) {
        try {
            return TeaModel.toMap(in);
        }
        catch (Exception e) {
            throw new TeaUtilException(e.getMessage(), e);
        }
    }

    public static void sleep(int millisecond) {
        try {
            Thread.sleep(millisecond);
        }
        catch (InterruptedException e) {
            throw new TeaUtilException(e.getMessage(), e);
        }
    }

    public static List<Map<String, Object>> toArray(Object input) {
        if (null == input) {
            return null;
        }
        try {
            List teaModels = (List)input;
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            for (TeaModel teaModel : teaModels) {
                if (null == teaModel) continue;
                result.add(teaModel.toMap());
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        seqId = new AtomicLong(0L);
        processStartTime = System.currentTimeMillis();
        Properties sysProps = System.getProperties();
        defaultUserAgent = String.format("AlibabaCloud (%s; %s) Java/%s %s/%s TeaDSL/1", sysProps.getProperty("os.name"), sysProps.getProperty("os.arch"), sysProps.getProperty("java.runtime.version"), "tea-util", "0.2.21");
    }
}

