/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tea.logging;

import com.aliyun.tea.logging.LogLevel;
import com.aliyun.tea.utils.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public final class DefaultLogger
extends MarkerIgnoringBase {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String WHITESPACE = " ";
    private static final String HYPHEN = " - ";
    private static final String OPEN_BRACKET = " [";
    private static final String CLOSE_BRACKET = "]";
    public static final String WARN = "WARN";
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String ERROR = "ERROR";
    public static final String TRACE = "TRACE";
    public static final String SDK_LOG_LEVEL = "ALIBABA_CLOUD_SDK_LOG_LEVEL";
    private final String classPath;
    private final boolean isTraceEnabled;
    private final boolean isDebugEnabled;
    private final boolean isInfoEnabled;
    private final boolean isWarnEnabled;
    private final boolean isErrorEnabled;

    public DefaultLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    public DefaultLogger(String className) {
        String classPath;
        try {
            classPath = Class.forName(className).getCanonicalName();
        }
        catch (ClassNotFoundException e) {
            classPath = className;
        }
        this.classPath = classPath;
        int configuredLogLevel = LogLevel.fromString(!StringUtils.isEmpty(this.loadFromEnvironment(SDK_LOG_LEVEL)) ? this.loadFromEnvironment(SDK_LOG_LEVEL) : WARN).getLogLevel();
        this.isTraceEnabled = LogLevel.VERBOSE.getLogLevel() > configuredLogLevel;
        this.isDebugEnabled = LogLevel.VERBOSE.getLogLevel() >= configuredLogLevel;
        this.isInfoEnabled = LogLevel.INFORMATIONAL.getLogLevel() >= configuredLogLevel;
        this.isWarnEnabled = LogLevel.WARNING.getLogLevel() >= configuredLogLevel;
        this.isErrorEnabled = LogLevel.ERROR.getLogLevel() >= configuredLogLevel;
    }

    @Override
    public String getName() {
        return this.classPath;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    @Override
    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.logMessageWithFormat(TRACE, msg, new Object[0]);
        }
    }

    @Override
    public void trace(String format, Object arg1) {
        if (this.isTraceEnabled()) {
            this.logMessageWithFormat(TRACE, format, arg1);
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(TRACE, format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.logMessageWithFormat(TRACE, format, arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log(TRACE, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    @Override
    public void debug(String msg) {
        this.logMessageWithFormat(DEBUG, msg, new Object[0]);
    }

    @Override
    public void debug(String format, Object arg) {
        this.logMessageWithFormat(DEBUG, format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(DEBUG, format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... args) {
        this.logMessageWithFormat(DEBUG, format, args);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(DEBUG, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    @Override
    public void info(String msg) {
        this.logMessageWithFormat(INFO, msg, new Object[0]);
    }

    @Override
    public void info(String format, Object arg) {
        this.logMessageWithFormat(INFO, format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(INFO, format, arg1, arg2);
    }

    @Override
    public void info(String format, Object ... args) {
        this.logMessageWithFormat(INFO, format, args);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log(INFO, msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isWarnEnabled;
    }

    @Override
    public void warn(String msg) {
        this.logMessageWithFormat(WARN, msg, new Object[0]);
    }

    @Override
    public void warn(String format, Object arg) {
        this.logMessageWithFormat(WARN, format, arg);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(WARN, format, arg1, arg2);
    }

    @Override
    public void warn(String format, Object ... args) {
        this.logMessageWithFormat(WARN, format, args);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log(WARN, msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isErrorEnabled;
    }

    @Override
    public void error(String format, Object arg) {
        this.logMessageWithFormat(ERROR, format, arg);
    }

    @Override
    public void error(String msg) {
        this.logMessageWithFormat(ERROR, msg, new Object[0]);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(ERROR, format, arg1, arg2);
    }

    @Override
    public void error(String format, Object ... args) {
        this.logMessageWithFormat(ERROR, format, args);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(ERROR, msg, t);
    }

    private void logMessageWithFormat(String levelName, String format, Object ... arguments) {
        FormattingTuple tp = MessageFormatter.arrayFormat(format, arguments);
        this.log(levelName, tp.getMessage(), tp.getThrowable());
    }

    private void log(String levelName, String message, Throwable t) {
        String dateTime = this.getFormattedDate();
        String threadName = Thread.currentThread().getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(dateTime).append(OPEN_BRACKET).append(threadName).append(CLOSE_BRACKET).append(OPEN_BRACKET).append(levelName).append(CLOSE_BRACKET).append(WHITESPACE).append(this.classPath).append(HYPHEN).append(message).append(System.lineSeparator());
        this.writeWithThrowable(stringBuilder, t);
    }

    private String getFormattedDate() {
        Date now = new Date();
        return DATE_FORMAT.format(now);
    }

    void writeWithThrowable(StringBuilder stringBuilder, Throwable t) {
        if (t != null) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                t.printStackTrace(pw);
                stringBuilder.append(sw.toString());
            }
        }
        System.out.print(stringBuilder.toString());
    }

    private String loadFromEnvironment(String name) {
        return !StringUtils.isEmpty(System.getenv(name)) ? System.getenv(name) : System.getProperty(name);
    }
}

