/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.utils.StringUtils;

public class SystemPropertiesCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    @Override
    public CredentialModel getCredentials() {
        String accessKeyId = System.getProperty("alibabacloud.accessKeyId");
        String accessKeySecret = System.getProperty("alibabacloud.accessKeySecret");
        if (!StringUtils.isEmpty(System.getProperty("alibabacloud.accessKeyIdSecret"))) {
            accessKeySecret = System.getProperty("alibabacloud.accessKeyIdSecret");
        }
        String securityToken = System.getProperty("alibabacloud.sessionToken");
        if (StringUtils.isEmpty(accessKeyId)) {
            throw new CredentialException("System property alibabacloud.accessKeyId cannot be empty.");
        }
        if (StringUtils.isEmpty(accessKeySecret)) {
            throw new CredentialException("System property alibabacloud.accessKeySecret cannot be empty.");
        }
        if (!StringUtils.isEmpty(securityToken)) {
            return CredentialModel.builder().accessKeyId(accessKeyId).accessKeySecret(accessKeySecret).securityToken(securityToken).type("sts").providerName(this.getProviderName()).build();
        }
        return CredentialModel.builder().accessKeyId(accessKeyId).accessKeySecret(accessKeySecret).type("access_key").providerName(this.getProviderName()).build();
    }

    @Override
    public String getProviderName() {
        return "system";
    }

    @Override
    public void close() {
    }
}

